package com.tykj.dev.device.user.subject.entity;

import com.tykj.dev.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UnitStoreLocation.java
 * @Description 存放位置信息
 * @createTime 2021年11月08日 12:46:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "单位对象", description = "单位详细信息")
public class UnitStoreLocation extends BaseEntity {

    private Integer unitId;

    private String storeName;

    private String typeName;

    @Column(name = "des",columnDefinition = "TEXT")
    private String des;

    private Integer showOrder;


}
