package com.tykj.dev.device.user.subject.entity;

import com.tykj.dev.device.user.base.ret.LeftNavigation;
import com.tykj.dev.device.user.base.ret.UnitsTrainVo;
import com.tykj.dev.device.user.base.ret.UnitsVo;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;

import javax.persistence.*;
import java.util.UUID;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName Units.java
 * @Description 单位对象
 * @createTime 2020年07月28日 09:23:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "单位对象", description = "单位详细信息")
@Where(clause = "id_del = 0")
@SQLDelete(sql = "update user set id_del = 1 where id = ?")
@Builder
public class Units {
    /**
     * 单位id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(value = "单位id", name = "unitId", example = "12321L")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer unitId;

    /**
     * 单位名称
     */
    @ApiModelProperty(value = "单位名称", name = "unitName", example = "12321L")
    private String name;

    /**
     * 单位描述
     */
    @ApiModelProperty(value = "单位描述", name = "unitDesc", example = "12321L")
    private String unitDesc;

    /**
     * 等级
     */
    @ApiModelProperty(value = "等级", name = "level", example = "12321L")
    private Integer level;

    /**
     * 是否删除
     */
    @ApiModelProperty(value = "是否删除", name = "idDel", example = "12321L")
    private Integer idDel=0;

    /**
     序列号
     */
    @ApiModelProperty(value = "序列号", name = "code", example = "12321L")
    private String code;

    /**
     * 1.在系统单位
     * 2.省直属单位 areaid 0
     * 3.省上级单位 areaid 0
     */
    private Integer type=1;

    /**
     * 区域id
     */
    @ApiModelProperty(value = "区域id", name = "areaId", example = "12321L")
    private Integer areaId;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序", name = "showOrder", example = "12321L")
    private Integer showOrder;

    @ApiModelProperty(value = "区域展示名称", name = "areaName", example = "12321L")
    @Transient
    private String areaName;

    @ApiModelProperty(value = "装备配用范围的指定")
    private Integer packingMatchingRange;

    @ApiModelProperty(value = "是否代管")
    private Integer escrow;

    @ApiModelProperty(value = "展示区域id")
    private Integer exhibitionId;

    @Transient
    @ApiModelProperty(value = "上级单位ID")
    private Integer parentUnitId;

    /**
     * 区域对象
     */
    @Transient
    private Area area;


    public static Units toDb() {
        return new Units(
                null,
                "省机要局",
                "秘密测试",
                1,
                0,
                "1234",
                1,1,
                null,
                null,
                null,
                null,
                null,
                null,
                null
        );
    }

    public UnitsVo toVo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, UnitsVo.class);
    }

    public UnitsTrainVo toUnitsTrainVo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, UnitsTrainVo.class);
    }


    public LeftNavigation toLeftNavigation(){
        return new LeftNavigation(unitId,name,null, UUID.randomUUID().toString(),2,showOrder,null);
    }

    /**
     * @return true = 是代管单位，false = 不是代管单位
     */
    public boolean isEscrow(){
        return escrow == 1;
    }
    /**
     * @return true = 不是代管单位，false = 是代管单位
     */
    public boolean isNotEscrow(){
        return escrow == 0;
    }

}
