package com.tykj.dev.device.user.subject.service;


import com.tykj.dev.device.user.subject.entity.Area;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.entity.User;

import java.util.List;

public interface UserPublicService {
    List<String> findByUnitNameDown(String unitName);

    /**
     * 通过Id查询用户
     */
    User getOne(Integer userId);

    /**
     * 通过用户ID查询单位name
     */
    String findUnitsNameByUserId(Integer userId);

    /**
     * 通过单位ID查询单位名称
     *
     * @param unitsId
     * @return
     */
    String findByUnitsToname(Integer unitsId);

    List<User> getAllUser();

    List<Units> getAllUnits();

    List<Integer> findAllUserIdByUnitsName(String unitName);

    Area getArea(Integer areaId);

    List<String> findAllUnitNameByAreaId(Integer areaId);

    List<String> findAllUnitNameByType2();

    Integer findUnitIdByName(String unitName);

    /**
     * @param userId 用户id
     * 查询该用户同级其他用户Id
     */
    List<Integer> findOtherUser(Integer userId);

    String getAreaNameByUnitName(String unitName);

    /**
     * 根据区域id查询单位id
     */
    List<Integer> findAllUnitIdByAreaId(Integer areaId);



    /*新的区域查询接口*/
    List<Units> accordingExhibitionIdAllUnits(Integer exhibitionId);

    /**
     * 根据单位id查询当前单位下的全部子对象，以及对象下的子对象
     * @return 单位集合
     */
    List<Units> findByUnitIdSubordinateAll(Integer unitId);


    /**
     * 根据展示区域id查询下级所有单位
     * @param areaExhibitionId 展示区域id
     * @return 单位id集合
     */
    List<Units> findByAreaExhibitionIdSubordinateAll(Integer areaExhibitionId);
}
