package com.tykj.dev.device.user.subject.service.impl;

import com.tykj.dev.device.user.cache.AreaExhibitionCache;
import com.tykj.dev.device.user.subject.dao.AreaExhibitionDao;
import com.tykj.dev.device.user.subject.entity.Area;
import com.tykj.dev.device.user.subject.entity.AreaExhibition;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.service.AreaExhibitionService;
import com.tykj.dev.misc.exception.ApiException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName AreaExhibitionServiceImpl.java
 * @Description TODO
 * @createTime 2021年11月09日 11:13:00
 */
@Service
public class AreaExhibitionServiceImpl implements AreaExhibitionService {
    @Autowired
    AreaExhibitionDao areaExhibitionDao;

    @Autowired
    AreaExhibitionCache areaExhibitionCache;

    @Override
    public List<AreaExhibition> finaAllAreaExhibition() {
        List<AreaExhibition> areaExhibitions=areaExhibitionDao.findAll().stream().sorted(Comparator.comparing(AreaExhibition::getOrders)).collect(Collectors.toList());
        areaExhibitions.forEach(
                areaExhibition -> {
                    if (areaExhibition.getFatherId()!=null) {
                       AreaExhibition areaExhibition1= areaExhibitionCache.findById(areaExhibition.getFatherId());
                       areaExhibition.setFatherName(areaExhibition1.getAreaName());
                    }
                }
        );
        return areaExhibitions;
    }

    @Override
    public AreaExhibition findById(Integer areaExhibitionId){
        Optional<AreaExhibition> optionalAreaExhibition = areaExhibitionDao.findById(areaExhibitionId);
        if (optionalAreaExhibition.isPresent()){
            return optionalAreaExhibition.get();
        }else {
            throw new ApiException("[区域展示] 根据id查询对象没找到："+areaExhibitionId);
        }
    }

    @Override
    public AreaExhibition save(AreaExhibition areaExhibition) {
        if (areaExhibition.getId()==null){
            areaExhibition.setOrders(areaExhibitionCache.findAll().size()+1);
        }else {
            AreaExhibition oldAreaExhibition = areaExhibitionCache.findById(areaExhibition.getId());
            int count=areaExhibitionCache.findAll().size();
            if (!oldAreaExhibition.getOrders().equals(areaExhibition.getOrders())){
                    if (count<areaExhibition.getOrders()){
                        areaExhibition.setOrders(count+1);
                    }else {
                        sortingAreaExhibition(areaExhibition.getOrders(),oldAreaExhibition.getOrders());
                    }
            }
        }
        AreaExhibition areaExhibition1= areaExhibitionDao.save(areaExhibition);
        areaExhibitionCache.refresh(areaExhibitionDao.findAll());
        return areaExhibition1;
    }

    private void sortingAreaExhibition(Integer originalOrder,Integer newOrder){
        List<AreaExhibition> areaExhibitions;
        if (originalOrder>newOrder){
            areaExhibitions=areaExhibitionCache.findListGeNewAndLtOriginal(newOrder,originalOrder);
            areaExhibitions.forEach(
                    areaExhibition -> areaExhibition.setOrders(areaExhibition.getOrders()+1)
            );
        }else {
            areaExhibitions=areaExhibitionCache.findListLgOriginalAndLeNew(newOrder,originalOrder);
            areaExhibitions.forEach(
                    areaExhibition -> areaExhibition.setOrders(areaExhibition.getOrders()-1)
            );
        }
        areaExhibitionCache.refresh(areaExhibitionDao.saveAll(areaExhibitions));
    }


    @Override
    public boolean delete(Integer id) {
        return false;
    }

    @Override
    public List<AreaExhibition> findAll() {
        return areaExhibitionDao.findAll();
    }

    @Override
    public AreaExhibition update(AreaExhibition areaExhibition) {
        AreaExhibition areaExhibition1= areaExhibitionDao.save(areaExhibition);
        areaExhibitionCache.refresh(areaExhibitionDao.findAll());
        return areaExhibition1;
    }
}
