package com.tykj.dev.device.user.subject.service.impl;

import com.tykj.dev.device.user.base.req.UnitStoreLocationVo;
import com.tykj.dev.device.user.subject.dao.UnitStoreLocationDao;
import com.tykj.dev.device.user.subject.entity.UnitStoreLocation;
import com.tykj.dev.device.user.subject.service.UnitStoreLocationService;
import com.tykj.dev.misc.base.BaseEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UnitStoreLocationServiceImpl.java
 * @Description TODO
 * @createTime 2021年11月08日 13:02:00
 */
@Service
public class UnitStoreLocationServiceImpl implements UnitStoreLocationService {

    @Autowired
    UnitStoreLocationDao unitStoreLocationDao;

    @Override
    public List<UnitStoreLocation> findAllByUnitIdAndTypeName(UnitStoreLocationVo unitStoreLocationVo) {
        return unitStoreLocationDao.findAllByUnitIdAndTypeName(unitStoreLocationVo.getUnitId(),unitStoreLocationVo.getTypeName()).stream().sorted(Comparator.comparing(UnitStoreLocation::getShowOrder)).collect(Collectors.toList());
    }

    @Override
    public Map<Integer, String> findByUnitIdToDeviceMap(Integer unitId) {

        return unitStoreLocationDao.findAllByUnitIdAndTypeName(unitId,"存放位置")
                .stream()
                .sorted(Comparator.comparing(UnitStoreLocation::getShowOrder))
                .collect(Collectors.toMap(UnitStoreLocation::getId,UnitStoreLocation::getStoreName));
    }

    @Override
    public Map<Integer, String> findByStorageLocationIds(List<Integer> ids) {
        List<UnitStoreLocation> storeLocations = unitStoreLocationDao.findAllByIdIn(ids);
        return storeLocations.stream().collect(Collectors.toMap(BaseEntity::getId, UnitStoreLocation::getStoreName));
    }

    @Override
    public UnitStoreLocation save(UnitStoreLocation unitStoreLocation) {
        return unitStoreLocationDao.save(unitStoreLocation);
    }

    @Override
    public boolean delete(Integer id) {
        return false;
    }

    @Override
    public List<UnitStoreLocation> findAll() {
        return unitStoreLocationDao.findAll().stream().sorted(Comparator.comparing(UnitStoreLocation::getShowOrder))
                .collect(Collectors.toList());
    }

    @Override
    public UnitStoreLocation update(UnitStoreLocation unitStoreLocation) {
        return unitStoreLocationDao.save(unitStoreLocation);
    }
}
