package com.tykj.dev.device.user.subject.service.impl;

import com.tykj.dev.device.user.subject.dao.UserRecordDao;
import com.tykj.dev.device.user.subject.entity.UserRecord;
import com.tykj.dev.device.user.subject.service.UserRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class UserRecordServiceImpl implements UserRecordService {

    @Autowired
    UserRecordDao userRecordDao;
    /**
     * 通用新增接口
     *
     * @param userRecord 对象
     * @return 对象
     */
    @Override
    public UserRecord save(UserRecord userRecord) {
        return userRecordDao.save(userRecord);
    }

    /**
     * 根据id删除数据
     *
     * @param id 数据id
     * @return 布尔
     */
    @Override
    public boolean delete(Integer id) {
        return false;
    }

    /**
     * 查询所有数据
     *
     * @return 数据集合
     */
    @Override
    public List<UserRecord> findAll() {
        return userRecordDao.findAll();
    }

    /**
     * 更新数据
     *
     * @param userRecord 对象
     * @return 对象
     */
    @Override
    public UserRecord update(UserRecord userRecord) {
        return userRecordDao.save(userRecord);
    }
}
