package com.tykj.dev.device.usereport.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.file.entity.WrodParameter;
import com.tykj.dev.device.file.service.UseReportFIleService;
import com.tykj.dev.device.user.cache.UnitsCache;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.service.UnitsService;
import com.tykj.dev.device.usereport.service.DeviceUseReportService;
import com.tykj.dev.device.usereport.subject.domin.DeviceUseReport;
import com.tykj.dev.device.usereport.subject.vo.DeviceUseReportCreateVo;
import com.tykj.dev.device.usereport.subject.vo.DeviceUseReportDetailVo;
import com.tykj.dev.device.usereport.subject.vo.DeviceUseReportSelectVo;
import com.tykj.dev.misc.base.ResultObj;
import com.tykj.dev.misc.utils.ResultUtil;
import com.tykj.dev.misc.utils.StringSplitUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;

/**
 * @author dengdiyi
 */
@RestController
@RequestMapping(value = "/check/report")
@AutoDocument
@Api(tags = "装备使用报告模块", description = "装备使用报告接口")
public class DeviceUseReportController {

    @Autowired
    private DeviceUseReportService deviceUseReportService;

    @Autowired
    UnitsService unitsService;

    @Resource
    private UnitsCache unitsCache;

    @Autowired
    private UseReportFIleService useReportFIleService;
    @ApiOperation(value = "模糊查询装备使用报告分页", notes = "可以通过这个接口模糊查询装备使用报告分页")
    @PostMapping("/summary")
    public ResponseEntity selectDeviceUseReport(@RequestBody DeviceUseReportSelectVo deviceUseReportSelectVo) {
        Page<DeviceUseReport> deviceUseReportEntities = deviceUseReportService.getPage(deviceUseReportSelectVo, deviceUseReportSelectVo.getPageable());
        return ResultUtil.success(deviceUseReportEntities);
    }

    @ApiOperation(value = "生成装备使用报告", notes = "可以通过这个接口生成装备使用报告")
    @PostMapping("/create")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity createDeviceUseReport(@RequestBody @Validated DeviceUseReportCreateVo deviceUseReportCreateVo, @ApiIgnore @AuthenticationPrincipal SecurityUser securityUser) {
        return ResultUtil.success(deviceUseReportService.createReport(deviceUseReportCreateVo));
    }

    @ApiOperation(value = "查询装备使用报告详情页", notes = "查询装备使用报告详情页")
    @GetMapping("/detail/{id}")
    public ResponseEntity selectDetail(@PathVariable("id") int id) {
        DeviceUseReport d = deviceUseReportService.getOne(id);
        DeviceUseReportDetailVo deviceUseReportDetailVo = new DeviceUseReportDetailVo();
        BeanUtils.copyProperties(d, deviceUseReportDetailVo);
        //分解数量详情组合字段
        List<Integer> list = StringSplitUtil.userIdSplit(d.getReportDetail());
        if (list.size() > 15) {
            deviceUseReportDetailVo.setDeviceNumber(list.get(0));
            deviceUseReportDetailVo.setInLibraryNum(list.get(1));
            deviceUseReportDetailVo.setSendRepairNum(list.get(2));
            deviceUseReportDetailVo.setReceiveRepairNum(list.get(3));
            deviceUseReportDetailVo.setDestoryNum(list.get(4));
            deviceUseReportDetailVo.setSendAllotNum(list.get(5));
            deviceUseReportDetailVo.setReceiveAllotNum(list.get(6));
            deviceUseReportDetailVo.setSendAllotBackNum(list.get(7));
            deviceUseReportDetailVo.setReceiveAllotBackNum(list.get(8));
            deviceUseReportDetailVo.setSendBackNum(list.get(9));
            deviceUseReportDetailVo.setScrapStatisticsNum(list.get(10));
            deviceUseReportDetailVo.setPackingNum(list.get(11));
            deviceUseReportDetailVo.setRetiredNum(list.get(12));
            deviceUseReportDetailVo.setDecommissioningStatisticsNum(list.get(13));
            deviceUseReportDetailVo.setToRepairBackNum(list.get(14));
            deviceUseReportDetailVo.setToRepairNum(list.get(15));
        }
        return ResultUtil.success(deviceUseReportDetailVo);
    }

    @ApiOperation(value = "装备使用报告下载", notes = "装备使用报告下载")
    @GetMapping("/download/{id}")
    public ResponseEntity getDownloadUrl(@PathVariable("id") int id, HttpServletResponse response, HttpServletRequest httpServletRequest) throws IOException {
        //获取详情
        ResultObj resultObj = (ResultObj) selectDetail(id).getBody();
        DeviceUseReportDetailVo deviceUseReportDetailVo = (DeviceUseReportDetailVo) resultObj.getData();
        //新建word模板
        WrodParameter wrodParameter = deviceUseReportDetailVo.toWrodParameter();
//        Units units= unitsService.findbyName(deviceUseReportDetailVo.getUnit());
//        Units units= unitsService.findById(deviceUseReportDetailVo.getUnitId());
        Units units= unitsCache.findById(deviceUseReportDetailVo.getUnitId());
        Instant instant = deviceUseReportDetailVo.getCreateTime().toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        wrodParameter.setTime(localDateTime.getYear()+"年"+localDateTime.getMonthValue()+"月"+localDateTime.getDayOfMonth()+"日");
        wrodParameter.setTitleUnitName(deviceUseReportDetailVo.getUnit());

        Instant instant1 = deviceUseReportDetailVo.getStartTime().toInstant();
        Instant instant2 = deviceUseReportDetailVo.getEndTime().toInstant();
        LocalDateTime localDateTime1 = LocalDateTime.ofInstant(instant1, zone);
        LocalDateTime localDateTime2 = LocalDateTime.ofInstant(instant2, zone);
        String startTime= localDateTime1.getYear()+"年"+localDateTime1.getMonthValue()+"月"+localDateTime1.getDayOfMonth()+"日";
        String endTime= localDateTime2.getYear()+"年"+localDateTime2.getMonthValue()+"月"+localDateTime2.getDayOfMonth()+"日";
        wrodParameter.setTitleTimeStart(startTime);
        wrodParameter.setTitleTimeEnd(endTime);
        wrodParameter.setTitleAnnual(localDateTime.getYear());
        if (units.getLevel()==1) {
            useReportFIleService.findToFileService(wrodParameter, response, httpServletRequest,"docxModel.docx");
        }else if(units.getLevel()==2){
            useReportFIleService.findToFileService(wrodParameter, response, httpServletRequest,"docxModel1.docx");

        }else {
            useReportFIleService.findToFileService(wrodParameter, response, httpServletRequest,"docxModel2.docx");
        }
        return ResponseEntity.ok("下载成功");
    }
}
