package com.tykj.dev.device.zxing.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.zxing.entity.PackageVersion;
import com.tykj.dev.device.zxing.service.PackageVersionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags = "系统版本管理模块", description = "系统版本管理模块接口")
@RequestMapping("/packageVersion")
@AutoDocument
public class PackageVersionController {

    @Autowired
    private PackageVersionService packageVersionService;

    @ApiOperation(value = "获取版本号")
    @GetMapping("/getVersion")
    public PackageVersion getVersion(){
        return packageVersionService.getVersion();
    }


}
