/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.internal;

import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.internal.DZHeader;
import com.zebra.sdk.util.internal.Base64;
import com.zebra.sdk.util.internal.FileReader;
import com.zebra.sdk.util.internal.FileUtilities;
import com.zebra.sdk.util.internal.PrinterFileDescriptor;
import com.zebra.sdk.util.internal.PrinterFilePath;
import com.zebra.sdk.util.internal.StringUtilities;
import com.zebra.sdk.util.internal.ZCRC16;
import com.zebra.sdk.util.internal.ZPLUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FileWrapper {
    public static final int SIZE_OF_DZ_HEADER = 16;
    public static final int SIZE_OF_LINKOS_DZ_HEADER = 24;
    public static final String CPCL_CRC16_FILE_HEADER_FOR_FLASH = "! CISDFCRC16";
    public static final String CPCL_CRC16_FILE_HEADER_FOR_RAM = "! CISDFRCRC16";
    private static final Set<String> validExtensionsToGetHzo = new HashSet<String>(Arrays.asList("FNT", "ZPL", "GRF", "DAT", "STO", "PNG"));

    private FileWrapper() {
    }

    public static boolean isHzoExtension(String string) {
        return validExtensionsToGetHzo.contains(string);
    }

    public static byte[] stripDzHeaderFromObjectData(String string, byte[] byArray) {
        byte by = 0;
        int n = 16;
        if (byArray[8] != by) {
            n = 24;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray, n, byArray.length - n);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (string.substring(string.lastIndexOf(46) + 1).equalsIgnoreCase("ZPL")) {
            return ZPLUtilities.replaceInternalCharactersWithReadableCharacters(byArray2);
        }
        return byArray2;
    }

    public static void stripDzHeaderFromObjectData(OutputStream outputStream, String string, byte[] byArray) throws ZebraIllegalArgumentException {
        byte by = 0;
        int n = 16;
        if (byArray[8] != by) {
            n = 24;
        }
        if (string.substring(string.lastIndexOf(46) + 1).equalsIgnoreCase("ZPL")) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, byArray.length - n);
            ZPLUtilities.replaceInternalCharactersWithReadableCharacters(outputStream, byteArrayInputStream);
        } else {
            try {
                outputStream.write(byArray, n, byArray.length - n);
            }
            catch (IOException iOException) {
                throw new ZebraIllegalArgumentException(iOException.getMessage());
            }
        }
    }

    public static byte[] decodeHZOData(String string) {
        boolean bl = string.indexOf("Z64:") >= 0;
        int n = string.indexOf("64:") + 3;
        int n2 = string.lastIndexOf(":");
        if (n >= 0 && n2 > n) {
            String string2 = string.substring(n, n2);
            return Base64.decode(string2, bl);
        }
        return null;
    }

    public static void unwrapHZOResult(OutputStream outputStream, String string, String string2) throws ZebraIllegalArgumentException {
        byte[] byArray = FileWrapper.decodeHZOData(string2);
        if (byArray == null || byArray.length <= 16) {
            throw new ZebraIllegalArgumentException("Malformed response from printer for " + string);
        }
        FileWrapper.stripDzHeaderFromObjectData(outputStream, string, byArray);
    }

    public static String wrapFile(File file, String string, boolean bl, boolean bl2) throws ZebraIllegalArgumentException {
        return FileWrapper.wrapFile(FileReader.toByteArray(file.getAbsolutePath()), string, bl, bl2);
    }

    public static String wrapFile(byte[] byArray, String string, boolean bl, boolean bl2) throws ZebraIllegalArgumentException {
        byte[] byArray2 = null;
        PrinterFilePath printerFilePath = FileUtilities.parseDriveAndExtension(string);
        String string2 = string.substring(string.lastIndexOf(46));
        byArray2 = DZHeader.getHeader(byArray, string, bl, bl2);
        byte[] byArray3 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(byArray2);
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byArray3 = byteArrayOutputStream.toByteArray();
        String string3 = Base64.encodeBytes(byArray3, 8);
        String string4 = ZCRC16.getCRC16ForZpl(string3);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ZPLUtilities.ZPL_INTERNAL_COMMAND_PREFIX);
        stringBuffer.append("DZ");
        stringBuffer.append(printerFilePath.getDrive());
        stringBuffer.append(":");
        stringBuffer.append(printerFilePath.getFileName());
        stringBuffer.append(string2);
        stringBuffer.append(ZPLUtilities.ZPL_INTERNAL_DELIMITER);
        stringBuffer.append(byArray3.length);
        stringBuffer.append(ZPLUtilities.ZPL_INTERNAL_DELIMITER);
        stringBuffer.append(":B64:");
        stringBuffer.append(string3);
        stringBuffer.append(":");
        stringBuffer.append(string4);
        return stringBuffer.toString();
    }

    public static byte[] wrapFileWithCisdfHeader(byte[] byArray, String string) {
        if (FileWrapper.alreadyContainsHeader(byArray)) {
            return byArray;
        }
        String string2 = FileWrapper.getHeaderString(string);
        String string3 = ZCRC16.getCRC16ForCisdfHeader(byArray).toUpperCase();
        String string4 = FileWrapper.convertTo16dot3(string);
        String string5 = StringUtilities.stringPadToPlaces(8, "0", Long.toHexString(byArray.length), false).toUpperCase();
        String string6 = ZCRC16.getWChecksum(byArray).toUpperCase();
        String string7 = string2 + "\r\n" + string3 + "\r\n" + string4 + "\r\n" + string5 + "\r\n" + string6 + "\r\n";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(string7.getBytes());
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(FileWrapper.getCisdfTrailer());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] getCisdfTrailer() {
        return "\r\n\r\n".getBytes();
    }

    public static String createCisdfHeader(PrinterFileDescriptor printerFileDescriptor) {
        String string = FileWrapper.getHeaderString(printerFileDescriptor.getName());
        String string2 = FileWrapper.convertTo16dot3(printerFileDescriptor.getName());
        String string3 = StringUtilities.stringPadToPlaces(8, "0", Long.toHexString(printerFileDescriptor.getFileSize()), false).toUpperCase();
        return string + "\r\n" + printerFileDescriptor.getCrc16() + "\r\n" + string2 + "\r\n" + string3 + "\r\n" + printerFileDescriptor.getCheckSum() + "\r\n";
    }

    private static String getHeaderString(String string) {
        String string2 = CPCL_CRC16_FILE_HEADER_FOR_FLASH;
        try {
            PrinterFilePath printerFilePath = FileUtilities.parseDriveAndExtension(string);
            String string3 = printerFilePath.getDrive();
            if (string3 != null && string3.toUpperCase().startsWith("R")) {
                string2 = CPCL_CRC16_FILE_HEADER_FOR_RAM;
            }
        }
        catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
            // empty catch block
        }
        return string2;
    }

    private static boolean alreadyContainsHeader(byte[] byArray) {
        String string = new String(byArray).trim();
        return string.startsWith(CPCL_CRC16_FILE_HEADER_FOR_FLASH) || string.startsWith(CPCL_CRC16_FILE_HEADER_FOR_RAM);
    }

    private static String convertTo16dot3(String string) {
        try {
            PrinterFilePath printerFilePath = FileUtilities.parseDriveAndExtension(string);
            int n = printerFilePath.getFileName().length() > 16 ? 16 : printerFilePath.getFileName().length();
            String string2 = printerFilePath.getFileName().substring(0, n);
            return new PrinterFilePath(printerFilePath.getDrive(), string2, printerFilePath.getExtension()).toString();
        }
        catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
            return "";
        }
    }

    public static String getFileName(File file) {
        String string = file.getName();
        String string2 = "";
        if (string.contains(".")) {
            string2 = string.substring(string.lastIndexOf(46) + 1);
            if (string2.length() > 3) {
                string2 = string2.substring(0, 3);
            }
            string = string.substring(0, string.lastIndexOf(46));
        }
        if (string.length() > 8) {
            string = string.substring(0, 8);
        }
        return string.toUpperCase() + (string2.equals("") ? "" : "." + string2.toUpperCase());
    }

    public static byte[] stripOffCISDFWrapper(byte[] byArray) {
        String string = new String(byArray);
        if (string.startsWith(CPCL_CRC16_FILE_HEADER_FOR_FLASH) || string.startsWith(CPCL_CRC16_FILE_HEADER_FOR_RAM)) {
            int n = 0;
            for (int i = 0; i < 5; ++i) {
                int n2;
                n = n2 = FileWrapper.findStartOfNextLine(string, n);
            }
            String string2 = string.substring(n);
            return string2.trim().getBytes();
        }
        return byArray;
    }

    private static int findStartOfNextLine(String string, int n) {
        boolean bl = false;
        int n2 = 0;
        for (int i = n; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl && c != '\r' && c != '\n') {
                n2 = i;
                break;
            }
            if (c != '\r' && c != '\n') continue;
            bl = true;
        }
        return n2;
    }
}

