package com.tykj.dev.device.task.subject.bto;

import com.tykj.dev.device.task.subject.domin.TaskLog;
import com.tykj.dev.device.library.subject.vo.FileVo;
import com.tykj.dev.device.task.subject.vo.TaskLogUserVo;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.misc.base.BeanHelper;
import com.tykj.dev.misc.utils.SpringUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TaskLogBto {

    @ApiModelProperty(name = "主键id")
    private Integer id;

    @ApiModelProperty(value = "业务id")
    private Integer taskId;

    @ApiModelProperty(value = "操作描述")
    private String remark;

    @ApiModelProperty(value = "附件信息")
    private List<FileVo> fileVoList;

    @ApiModelProperty(value = "操作人")
    private Integer createUserId;

    @ApiModelProperty(value = "操作时间")
    private Date createTime;

    /**
     * dto类转化为do类
     */
    public TaskLog toDo(){
        TaskLog taskLog = new TaskLog();
        taskLog.setTaskId(this.taskId);
        taskLog.setRemark(this.remark);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Ǵ");
        if (this.fileVoList!=null&&this.fileVoList.size()>0) {
            for (FileVo f : this.fileVoList) {
                stringBuffer.append(f.getFileName());
                stringBuffer.append("Ǒ");
                stringBuffer.append(f.getFileUrl());
                stringBuffer.append("Ǒ");
                stringBuffer.append(f.getTitle());
                stringBuffer.append("Ǵ");
            }
        }
        taskLog.setFileDetail(stringBuffer.toString());
        return taskLog;
    }

    public TaskLogBto(Integer taskId, String remark, List<FileVo> fileVoList) {
        this.taskId = taskId;
        this.remark = remark;
        this.fileVoList = fileVoList;
    }

    /**
     * bto类转化为vo类
     */
    public TaskLogUserVo toVo(){
        UserPublicService userPublicService = SpringUtils.getBean("userPublicServiceImpl");
        //复制相同属性
        ModelMapper modelMapper = BeanHelper.getUserMapper();
        TaskLogUserVo taskLogUserVo = modelMapper.map(this,TaskLogUserVo.class);
        //set vo字段
        if (userPublicService!=null){
            taskLogUserVo.setUser(userPublicService.getOne(this.createUserId).getName());
            taskLogUserVo.setUnit(userPublicService.findUnitsNameByUserId(this.createUserId));
        }
        return taskLogUserVo;
    }
}
