package com.tykj.dev.device.task.subject.common;

import lombok.AllArgsConstructor;

/**
 * @author dengdiyi
 * 业务状态枚举
 */

@AllArgsConstructor
public enum StatusEnum {



    /**
     * RFID标签制作
     */
    CREATE_RFID_BUSINESS(8100,"标签制作业务开始"),
    RFID_BUSINESS_NEED_CONFIRM(8101,"等待审核"),
    RFID_BUSINESS_CONFIRM_FINISH_SUCCESS(8102,"审核成功"),
    RFID_BUSINESS_CONFIRM_FINISH_FAILED(8103,"审核失败"),

    /**
     * 销毁业务
     */
    CREATE_DESTROY_BUSINESS(8110,"标签制作业务开始"),
    DESTROY_BUSINESS_NEED_CONFIRM(8111,"等待审核"),
    DESTROY_BUSINESS_CONFIRM_FINISH_SUCCESS(8112,"审核成功"),
    DESTROY_BUSINESS_CONFIRM_FINISH_FAILED(8113, "审核失败"),

    /**
     * 退装业务
     */
    CREATE_RETIRED_BUSINESS(8120, "标签制作业务开始"),
    RETIRED_BUSINESS_NEED_CONFIRM(8121, "等待审核"),
    RETIRED_BUSINESS_CONFIRM_FINISH_SUCCESS(8122, "审核成功"),
    RETIRED_BUSINESS_CONFIRM_FINISH_FAILED(8123, "审核失败"),

    /**
     * 核查任务
     */
    //以下为stat状态
    CHECK_STAT_0(100, "省级统计数据收集中"),
    CHECK_STAT_1(101, "省级统计数据等待确认"),

    //以下为detail状态
    CHECK_DETAIL_0(120, "等待专管员A处理"),
    CHECK_DETAIL_1(121, "等待专管员B处理"),
    CHECK_DETAIL_2(122, "等待核查员A处理"),
    CHECK_DETAIL_3(123, "等待核查员B处理"),


    /**
     * 业务完结
     */
    END(9999, "业务完结"),

    TRAIN1000(1000, "报名中"),

    TRAIN1001(1001, "报名确认"),

    TRAIN1002(1002,"待报名"),

    TRAIN1003(1003,"等待培训"),

    TRAIN1004(1004,"培训中"),

    TRAIN1005(1005,"申请发证"),

    TRAIN1006(1006,"市培训申请发证审核"),

    TRAIN1007(1007,"省培训发证审核"),

    TRAIN1008(1008,"成绩录入"),

    TRAIN1009(1009,"成绩确认"),
//
    TRAIN1010(1010,"待培训"),
//
//    TRAIN1011(1011,""),
//
//    TRAIN1012(1012,""),
//
//    TRAIN1013(1013,""),

    /**
     * 业务封存
     */
    ARCHIVE(8888,"业务封存"),

    /**
     * 列装待审核
     */
    PACKING_CONFIRM(100,"列装待审核"),

    /**
     * 入库待审核
     */
    STORAGE_CONFIRM(200,"入库待审核"),

    /**
     * 待配发
     */
    WAIT_ALLOT(300,"待配发"),

    /**
     * 配发出库待审核
     */
    ALLOT_SEND_CONFIRM(301,"配发出库待审核"),

    /**
     * 配发中
     */
    ALLOTING(302,"配发中"),

    /**
     * 配发入库待审核
     */
    ALLOT_RECEIVE_CONFIRM(303,"配发入库待审核"),

    /**
     * 待自查
     */
    WAIT_SELF_CHECK(400,"待自查"),

    /**
     * 自查待审核
     */
    SELF_CHECK_CONFIRM(401,"自查待审核"),

    /**
     * 装备申请待批复
     */
    DEVICE_APPLY_CONFIRM(500,"装备申请待批复"),
    /**
     * 新增配套设备待审核
     */
    ADD_MATCHING_DEVICE_CONFIRM(600,"新增配套设备待审核"),

    /**
     * 维修送修状态
     */
    REPAIR_SEND_CONFIRM(700,"维修送修出库待审核"),
    WAIT_RECEIVE(701,"等待接收维修装备"),
    REPAIR_RECEIVE_CONFIRM(702,"接收维修装备待审核"),
    REPAIRING(703,"维修中"),
    /**
     * 维修完成退回状态
     */
    REPAIR_BACK_CONFIRM(800,"维修退回装备出库待审核"),
    WAIT_BACK_RECEIVE(801,"等待接收维修装备"),
    REPAIR_BACK_RECEIVE_CONFIRM(802,"接收维修装备待审核")
    ;

    public Integer id;

    public String name;
}
