package com.tykj.dev.device.user.subject.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RolePermissions.java
 * @Description 角色权限关联对象
 * @createTime 2020年07月29日 08:52:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "角色权限关联对象", description = "角色权限关联对象详细信息")
public class RolePermissions {
    /**
     * id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "数据ID", name = "rpId", example = "12321L")
//    @GeneratedValue(generator="UserIdentityGenerator",strategy = GenerationType.AUTO)
//    @GenericGenerator(name = "UserIdentityGenerator", strategy = "UserIdentityGenerator")
    private Integer rpId;

    /**
     * 角色id
     */
    @ApiModelProperty(value = "角色id", name = "roleId", example = "12321L")
    private Integer roleId;

    /**
     * 权限id
     */
    @ApiModelProperty(value = "权限id", name = "permissionsId", example = "12321L")
    private Integer permissionsId;
}
