package com.tykj.dev.device.user.subject.service.impl;

import com.tykj.dev.device.user.subject.dao.UserRoleDao;
import com.tykj.dev.device.user.subject.entity.UserRole;
import com.tykj.dev.device.user.subject.service.UserRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UserRoleServiceImpl.java
 * @Description 用户角色关联逻辑层
 * @createTime 2020年07月27日 15:07:00
 */
@Service
public class UserRoleServiceImpl implements UserRoleService {
    @Autowired
    UserRoleDao userRoleDao;

    @Override
    public UserRole save(UserRole userRole) {
        return userRoleDao.save(userRole);
    }

    @Override
    public boolean delete(Integer id) {
        userRoleDao.deleteById(id);
        return true;
    }

    @Override
    public List<UserRole> findAll() {
        return userRoleDao.findAll();
    }

    @Override
    public UserRole update(UserRole userRole) {
        return userRoleDao.save(userRole);
    }

    @Override
    public List<UserRole> findByUserId(Integer userId) {
        return userRoleDao.findAllByUserId(userId);
    }
}
