import com.tykj.dev.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.*;

/**
 * @author zjm
 */
@RestController
@RequestMapping(value = "/scrap")
@AutoDocument
@Api(tags = "报废模块",description = "报废模块")
public class DeviceScrapController {


    @ApiOperation(value = "查询列表",notes = "可以通过这个接口查询销毁单")
    @PostMapping(value = "/summary")
    public ResponseEntity<com.tykj.dev.device.scrap.ScrapPage> selectRepairBill(@RequestBody ScrapConditions scrapConditions){
        List<ScrapListVo> listVos=new ArrayList<>();
        Long time=1598163550704L;
        listVos.add(new ScrapListVo(1,"No2.2019号WX12","张馋","李思念","伸莎","MB-001,MC-001","密码机",new Date(time),"国家密码局","192.168.102.211:8087/status/1.jpeg","陈龚",null));
        listVos.add(new ScrapListVo(2,"No2.2019号WX13","李生成","许仁","詹彻","MA-001,MP-001","密码机",new Date(time),"国家密码局","192.168.102.211:8087/status/1.jpeg","陈龚",null));
        listVos.add(new ScrapListVo(3,"No2.2019号WX14","鲍若人","李奕","陈行","MC-001,M1-001","密码机",new Date(time),"国家密码局","192.168.102.211:8087/status/1.jpeg","陈龚",null));
        listVos.add(new ScrapListVo(4,"No2.2019号WX15","李力","石彻","陈镇","MK-001,MC-001","密码机",new Date(time),"国家密码局","192.168.102.211:8087/status/1.jpeg","陈龚",null));

        if (scrapConditions.getDimName()!=null) {
            for (int i = 0; i < listVos.size(); i++) {
                if (((ScrapListVo) (listVos.get(i))).getName().indexOf(scrapConditions.getDimName()) <= -1)
                    listVos.remove(i);
            }
        }
        if (scrapConditions.getEndTime()!=null && scrapConditions.getStatusTime()!=null) {
            listVos.forEach(
                    scrapListVo -> {
                        if (scrapConditions.getStatusTime().getTime() < time && scrapConditions.getEndTime().getTime() > time) {

                        } else {
                            listVos.remove(scrapListVo);
                        }
                    }
            );
        }

       return ResponseEntity.ok(com.tykj.dev.device.scrap.ScrapPage.builder().data(listVos)
       .page(scrapConditions.getPage()).size(scrapConditions.getSize()).total(listVos.size()).build());
    }




    @ApiOperation(value = "查询列表",notes = "可以通过这个接口查询销毁单")
    @PostMapping(value = "/summary/{scrapId}")
    public ResponseEntity<ScrapListVo> selectRepairBill1( @PathVariable Integer scrapId){
        Map<Integer,ScrapListVo> map=new HashMap<>();
        map.put(1,new ScrapListVo(1,"No2.2019号WX12","张馋","李思念","伸莎","MB-001,MC-001","密码机",new Date(),"国家密码局","192.168.102.211:8087/status/1.jpeg","陈龚",null));
        map.put(2,new ScrapListVo(2,"No2.2019号WX13","李生成","许仁","詹彻","MA-001,MP-001","密码机",new Date(),"国家密码局","192.168.102.211:8087/status/1.jpeg","陈龚",null));

        map.put(3,new ScrapListVo(3,"No2.2019号WX14","鲍若人","李奕","陈行","MC-001,M1-001","密码机",new Date(),"国家密码局","192.168.102.211:8087/status/1.jpeg","陈龚",null));

        map.put(4,new ScrapListVo(4,"No2.2019号WX15","李力","石彻","陈镇","MK-001,MC-001","密码机",new Date(),"国家密码局","192.168.102.211:8087/status/1.jpeg","陈龚",null));

        List<DeviceVo> listVos=new ArrayList<>();
        Random rand = new Random();

        // nextInt is normally exclusive of the top value,
        // so add 1 to make it inclusive
        int randomNum = rand.nextInt((1000 - 1) + 1) + 1;

        for (int i=0;i<3;i++){
            DeviceVo deviceVo =DeviceVo.toDo();
            deviceVo.setModel("M"+randomNum);
            listVos.add(deviceVo);
        }
        ScrapListVo scrapListVo=map.get(scrapId);
        scrapListVo.setList(listVos);

       return ResponseEntity.ok(scrapListVo);
    }




}
