import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName entity.java
 * @Description TODO
 * @createTime 2020年08月19日 16:07:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "专管员对象", description = "专管员记录")
public class ScrapListVo{
    /**
     * 主键id
     */
    @ApiModelProperty(name = "主键id")
    private Integer id ;

    /**
     * 文号
     */
    @ApiModelProperty(value = "文号")
    private String docNumber ;
    /**
     * 监销人
     */
    @ApiModelProperty(value = "监销人")
    private String supervisor ;
    /**
     * 主管领导
     */
    @ApiModelProperty(value = "主管领导")
    private String leader ;
    /**
     * 承办人
     */
    @ApiModelProperty(value = "承办人")
    private String undertaker ;

    /**
     * 型号
     */
    @ApiModelProperty(value = "型号")
    private String model;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 报废时间
     */
    @ApiModelProperty(value = "报废时间")
    private Date scrap;

    /**
     * 报废单位
     */
    private String unitsName;

    private String url;

    private String v1;

    private List<DeviceVo> list;
}
