package com.tykj.dev.device.sendback.subject.domin;

import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * entity class for send_back_bill_detail
 * 清退详情账单
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update send_back_bill_detail set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("清退详情账单")
public class SendBackBillDetail {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty(name = "主键id")
	private Integer id;
	/**
	* 申请文号
	*/
	@ApiModelProperty(value = "申请文号")
	private String applyNumber;
	/**
	* 批复文号
	*/
	@ApiModelProperty(value = "批复文号")
	private String replayNumber;
	/**
	* 发件单位
	*/
	@ApiModelProperty(value = "发件单位")
	private String sendUnit;
	/**
	* 收件单位
	*/
	@ApiModelProperty(value = "收件单位")
	private String receiveUnit;
	/**
	* 配发时间
	*/
	@ApiModelProperty(value = "配发时间")
	private Date sendTime;
	/**
	* 接收时间
	*/
	@ApiModelProperty(value = "接收时间")
	private Date receiveTime;
	/**
	* 发件方id(A岗位)
	*/
	@ApiModelProperty(value = "发件方id(A岗位)")
	private Integer sendUseraId;
	/**
	* 发件方id(B岗位)
	*/
	@ApiModelProperty(value = "发件方id(B岗位)")
	private Integer sendUserbId;
	/**
	* 收件方id(A岗位)
	*/
	@ApiModelProperty(value = "收件方id(A岗位)")
	private Integer receiveUseraId;
	/**
	* 收件方id(B岗位)
	*/
	@ApiModelProperty(value = "收件方id(B岗位)")
	private Integer receiveUserbId;
	/**
	* 出库附件文件名
	*/
	@ApiModelProperty(value = "出库附件文件名")
	private String fileName;
	/**
	* 出库附件文件地址URL
	*/
	@ApiModelProperty(value = "出库附件文件地址URL")
	private String fileUrl;
	/**
	* 账单文件名
	*/
	@ApiModelProperty(value = "账单文件名")
	private String billFileName;
	/**
	* 账单文件地址URL
	*/
	@ApiModelProperty(value = "账单文件地址URL")
	private String billFileUrl;
	/**
	* 退回状态(1:退回待审核,2:退回审核失败,3:退回中,4:退回接收待审核,5:退回接收审核失败,6:退回成功)
	*/
	@ApiModelProperty(value = "退回状态(1:退回待审核,2:退回审核失败,3:退回中,4:退回接收待审核,5:退回接收审核失败,6:退回成功)")
	private Integer sendBackStatus;
	/**
	* 退回装备数量
	*/
	@ApiModelProperty(value = "退回装备数量")
	private Integer sendBackCount;
	/**
	* 已出库装备数量
	*/
	@ApiModelProperty(value = "已出库装备数量")
	private Integer sendedCount;
	/**
	* 已接收装备数量
	*/
	@ApiModelProperty(value = "已接收装备数量")
	private Integer receiveCount;
	/**
	* 出库检查详情(装备主键id+核对结果(0缺失1无误3新增,字符x作为分隔符)),例如x10x21x32x,意为主键id为1的装备缺失,为2的无误,为3的不匹配
	*/
	@ApiModelProperty(value = "出库检查详情(装备主键id+核对结果(0缺失1无误3新增,字符x作为分隔符)),例如x10x21x32x,意为主键id为1的装备缺失,为2的无误,为3的不匹配")
	private String sendCheckDetail;
	/**
	* 出库检查结果(缺失数量x新增数量),例如1x1,意为缺失1台,新增一条
	*/
	@ApiModelProperty(value = "出库检查结果(缺失数量x新增数量),例如1x1,意为缺失1台,新增一条")
	private String sendCheckResult;
	/**
	* 接收方入库检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如x10x21x32x,意为主键id为1的装备缺失,为2的无误,为3的不匹配
	*/
	@ApiModelProperty(value = "接收方入库检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如x10x21x32x,意为主键id为1的装备缺失,为2的无误,为3的不匹配")
	private String receiveCheckDetail;
	/**
	* 接收方检查结果(缺失数量x新增数量),例如1x1,意为缺失1台,新增一条
	*/
	@ApiModelProperty(value = "接收方检查结果(缺失数量x新增数量),例如1x1,意为缺失1台,新增一条")
	private String receiveCheckResult;
	/**
	* Ǵ作为分隔符,维修装备的主键id加备注,例如x1Ǵ备注1Ǵx2Ǵ备注2Ǵx,意为id为1的装备在维修，备注为备注1,id为2的装备在维修，备注为备注2
	*/
	@ApiModelProperty(value = "Ǵ作为分隔符,维修装备的主键id加备注,例如x1Ǵ备注1Ǵx2Ǵ备注2Ǵx,意为id为1的装备在维修，备注为备注1,id为2的装备在维修，备注为备注2")
	private String repairDeviceDetail;
	/**
	* 创建用户id
	*/
	@CreatedBy
	@ApiModelProperty(value = "创建用户id")
	private Integer createUserId;
	/**
	* 创建时间
	*/
	@CreatedDate
	@ApiModelProperty(value = "创建时间")
	private Date createTime;
	/**
	* 更新用户id
	*/
	@LastModifiedBy
	@ApiModelProperty(value = "更新用户id")
	private Integer updateUserId;
	/**
	* 更新时间
	*/
	@LastModifiedDate
	@ApiModelProperty(value = "更新时间")
	private Date updateTime;
	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
	private Integer deleteTag;



	/****************czq**************/


	@ApiModelProperty(value = "发件方名称(A岗位)")
	private String sendUseraName;

	@ApiModelProperty(value = "发件方名称(B岗位)")
	private String sendUserbName;

	@ApiModelProperty(value = "收件方名称(A岗位)")
	private String receiveUseraName;

	@ApiModelProperty(value = "收件方名称(B岗位)")
	private String receiveUserbName;

	@ApiModelProperty(value = "装备id")
	private String deviceIds;

	@ApiModelProperty(value = "签发人")
	private String agent;

	@Transient
	@ApiModelProperty(value = "装备List")
	private List<DeviceLibrary> deviceLibraryEntities;

}
