package com.tykj.dev.device.packing.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.packing.service.PackingLibraryService;
import com.tykj.dev.device.packing.subject.domin.PackingLibrary;
import com.tykj.dev.device.packing.subject.vo.PackingDetailVo;
import com.tykj.dev.device.packing.subject.vo.PackingLibraryConfirmVo;
import com.tykj.dev.device.packing.subject.vo.PackingLibrarySaveVo;
import com.tykj.dev.device.packing.subject.vo.PartSaveVo;
import com.tykj.dev.device.task.service.TaskLogService;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.bto.TaskLogBto;
import com.tykj.dev.device.task.subject.common.BusinessEnum;
import com.tykj.dev.device.task.subject.common.StatusEnum;
import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.device.task.subject.vo.TaskLogUserVo;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.device.user.util.UserUtils;
import com.tykj.dev.misc.utils.ResultUtil;
import com.tykj.dev.socket.MyWebSocket;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@Api(tags = "列装管理模块",description = "列装管理接口")
@AutoDocument
@RequestMapping("/packing")
public class PackingController {

    @Autowired
    PackingLibraryService packingLibraryService;

    @Autowired
    TaskService taskService;

    @Autowired
    UserUtils userUtils;

    @Autowired
    UserPublicService userPublicService;

    @Autowired
    TaskLogService taskLogService;

    @Autowired
    MyWebSocket myWebSocket;

    @ApiOperation(value = "新增列装", notes = "可以通过这个接口发起列装")
    @PostMapping("/addPackingLibrary")
    public ResponseEntity addPackingLibrary(@RequestBody PackingLibrarySaveVo packingLibrarySaveVo) {
        //添加列装装备信息
        PackingLibrary p = packingLibrarySaveVo.toDo();
        p.setUseraId(userUtils.getCurrentUserId());
        PackingLibrary packingLibraryEntity = packingLibraryService.addEntity(p);
        //添加列装配件信息
        for (PartSaveVo part : packingLibrarySaveVo.getPartList()) {
            PackingLibrary p2 = new PackingLibrary();
            BeanUtils.copyProperties(p, p2);
            BeanUtils.copyProperties(part, p2);
            p2.setId(null);
            p2.setIsPart(1);
            p2.setPartParentId(packingLibraryEntity.getId());
            packingLibraryService.addEntity(p2);
        }
        //发起业务
        Integer userId = userUtils.getCurrentUserId();
        List<Integer> userIds = new ArrayList<>();
        userIds.add(userId);
        userIds.add(packingLibrarySaveVo.getUserbId());
        TaskBto taskBto = new TaskBto(StatusEnum.PACKING_CONFIRM.id,"列装业务",null,".",packingLibraryEntity.getId(),1,userUtils.getCurrentUnitId(),1,null,userIds);
        Task saveEntity = taskService.start(taskBto);
        //添加业务日志
        TaskLogBto taskLogBto = new TaskLogBto(saveEntity.getId(),"发起列装",null);
        taskLogService.addLog(taskLogBto);
        myWebSocket.sendMessage1();
        return ResultUtil.success(packingLibraryEntity);
    }

    @ApiOperation(value = "列装审核", notes = "可以通过这个接口进行列装审核")
    @PostMapping("/confirmPackingLibrary")
    public ResponseEntity confirmPackingLibrary(@RequestBody PackingLibraryConfirmVo packingLibraryConfirmVo) {
        TaskBto taskBto = taskService.get(packingLibraryConfirmVo.getTaskId());
        //审核通过
        if (packingLibraryConfirmVo.getStatus() == 0) {
            //业务完结
            taskService.update(taskService.moveToEnd(taskBto));
            //更改列装装备和配件的状态
            PackingLibrary packingLibraryEntity = packingLibraryService.getOne(taskBto.getBillId());
            packingLibraryEntity.setPackingStatus(2);
            for (PackingLibrary p : packingLibraryService.selectAllPart(taskBto.getBillId())) {
                p.setPackingStatus(2);
                packingLibraryService.update(p);
            }
            packingLibraryService.update(packingLibraryEntity);
            //添加业务日志
            TaskLogBto taskLogBto = new TaskLogBto(taskBto.getId(),"列装审核成功",null);
            taskLogService.addLog(taskLogBto);
            myWebSocket.sendMessage1();
            return ResultUtil.success("审核通过列装成功");
        }
        //审核失败
        if (packingLibraryConfirmVo.getStatus()==1){
            //业务封存
            taskService.moveToArchive(taskBto);
            //更改列装装备和配件的状态
            PackingLibrary packingLibraryEntity = packingLibraryService.getOne(taskBto.getBillId());
            packingLibraryEntity.setPackingStatus(1);
            for (PackingLibrary p:packingLibraryService.selectAllPart(taskBto.getBillId())) {
                p.setPackingStatus(2);
                packingLibraryService.update(p);
            }
            packingLibraryService.update(packingLibraryEntity);
            //添加业务日志
            TaskLogBto taskLogBto = new TaskLogBto(taskBto.getId(),"列装审核失败",null);
            taskLogService.addLog(taskLogBto);
            myWebSocket.sendMessage1();
            return ResultUtil.success("列装审核失败");
        }
        else {
            return ResultUtil.failed("status只能为0或1");
        }
    }

    @ApiOperation(value = "查询列装详情", notes = "可以通过这个接口查询列装详情")
    @GetMapping(value = "/detail/{billId}")
    public ResponseEntity selectDetail(@PathVariable("billId") int billId) {
        PackingDetailVo packingDetailVo = new PackingDetailVo();
        //获取taskBto
        TaskBto taskBto = taskService.get(billId, BusinessEnum.PACKING.id);
        //获取列装主件
        PackingLibrary packingLibraryEntity = packingLibraryService.getOne(billId);
        packingLibraryEntity.setUserA(userPublicService.getOne(packingLibraryEntity.getUseraId()).getName());
        packingLibraryEntity.setUserB(userPublicService.getOne(packingLibraryEntity.getUserbId()).getName());
        packingDetailVo.setPackingLibrary(packingLibraryEntity);
        //获取所有配件
        List<PackingLibrary> packingLibraryEntities = packingLibraryService.selectAllPart(billId);
        packingDetailVo.setParts(packingLibraryEntities);
        //获取业务日志
        List<TaskLogUserVo> taskLogUserVos = taskLogService.getByTaskId(taskBto.getId());
        packingDetailVo.setTaskLogUserVos(taskLogUserVos);
        return ResultUtil.success(packingDetailVo);
    }
}
