package com.tykj.dev.device.user.base.beabs;

import com.tykj.dev.device.user.util.UserUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.AuditorAware;

import java.util.Optional;

/**
 * @author dengdiyi
 */
@Configuration
public class UserIDAuditorBean implements AuditorAware<Integer> {
    /*
     *实现jpa自动插入当前用户id
     */
    @Override
    public Optional<Integer> getCurrentAuditor() {
        //获取当前用户Id并返回
        UserUtils userUtils = com.tykj.dev.misc.utils.SpringUtils.getBean("userUtils");
        Integer userId = null;
        if (userUtils != null) {
            userId = userUtils.getCurrentUserId();
        }
        if (userId != null){
            return Optional.of(userId);
        }
        else {
            return Optional.empty();
        }
    }
}
