package com.tykj.dev.device.user.util;

import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.service.UnitsService;
import com.tykj.dev.misc.utils.SpringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author dengdiyi
 * @description 用户信息相关工具类
 */
@Component
public class UserUtils {

    @Autowired
    private AuthenticationUtils AuthenticationUtils;

    @Autowired
    private UnitsService unitsService;

    public Integer getCurrentUserId() {
        SecurityUser authentication = AuthenticationUtils.getAuthentication();
        if (authentication != null) {
            return authentication.getCurrentUserInfo().getUserId();
        } else {
            return null;
        }
    }

    public String getCurrentUserName(){
        SecurityUser authentication = AuthenticationUtils.getAuthentication();
        return authentication.getCurrentUserInfo().getUsername();
    }

    public String getCurrentUserUnitName(){
        SecurityUser authentication = AuthenticationUtils.getAuthentication();
        Integer unitId = authentication.getCurrentUserInfo().getUnitsId();
        return unitsService.findById(unitId).getName();
    }

    public Integer getCurrentUnitLevel(){
        SecurityUser authentication = AuthenticationUtils.getAuthentication();
        Integer unitId = authentication.getCurrentUserInfo().getUnitsId();
        return unitsService.findById(unitId).getLevel();
    }

    public Integer getCurrentUnitId(){
        SecurityUser authentication = AuthenticationUtils.getAuthentication();
        return authentication.getCurrentUserInfo().getUnitsId();
    }
}
