/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.fileConversion.internal;

import java.io.IOException;
import java.io.InputStream;

public class HzoToDzConverterStream
extends InputStream {
    private InputStream sourceStream;
    String fakeDyHeader = "";
    int readCounter = 0;
    private boolean preambleSkipped = false;

    public HzoToDzConverterStream(InputStream inputStream) throws IOException {
        this.sourceStream = inputStream;
        if (inputStream == null) {
            throw new IOException("input stream is null");
        }
    }

    @Override
    public int read() throws IOException {
        int n;
        if (!this.preambleSkipped) {
            this.skipPreamble();
        }
        if ((n = this.sourceStream.read()) == 93) {
            while (-1 != n) {
                n = this.sourceStream.read();
            }
        }
        return n;
    }

    private void skipPreamble() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.sourceStream.read();
        if (-1 == n) {
            throw new IOException("File not found");
        }
        while (n != -1) {
            stringBuffer.append(String.format("%c", n));
            if (stringBuffer.toString().endsWith("<![CDATA[")) break;
            n = this.sourceStream.read();
        }
        this.preambleSkipped = true;
    }
}

