package com.tykj.dev.device.task.subject.bto;

import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.misc.base.BeanHelper;
import com.tykj.dev.misc.utils.StringSplitUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.util.List;

/**
 * @author dengdiyi
 */

@Data
@NoArgsConstructor
@AllArgsConstructor
public class TaskBto {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "主键id")
    private Integer id;

    @ApiModelProperty(value = "任务状态")
    private Integer billStatus;

    @ApiModelProperty(value = "任务标题")
    private String title;

    @ApiModelProperty(value = "父任务主键id")
    private Integer parentTaskId;

    @ApiModelProperty(value = "所有节点任务id组合,例如.1.2.,意为从根节点到当前节点所经历的节点为1和2")
    private String nodeIdDetail;

    @ApiModelProperty(value = "对应账单ID")
    private Integer billId;

    @ApiModelProperty(value = "业务类型主键id")
    private Integer bussinessType;

    @ApiModelProperty(value = "所属单位")
    private Integer ownUnit;

    @ApiModelProperty(value = "数字类型，用于代表指针目前的下标")
    private Integer currentPoint;

    @ApiModelProperty(value = "自定义信息，针对不同业务需要保存一些自定信息")
    private String customInfo;

    @ApiModelProperty(value = "置顶用户id的List")
    private List<Integer> topFlagDetailList;

    @ApiModelProperty(value = "阅读过用户id的List")
    private List<Integer> userReadDetailList;

    @ApiModelProperty(value = "工作涉及人员id")
    private List<Integer> involeUserIdList;

    /**
     * bto类转化为do类
     */
    public Task toDo(){
        //复制相同属性
        ModelMapper modelMapper = BeanHelper.getUserMapper();
        Task task = modelMapper.map(this,Task.class);
        task.setInvolveUsers(StringSplitUtil.idListToString(this.involeUserIdList));
        task.setUserReadDetail(StringSplitUtil.idListToString(this.userReadDetailList));
        task.setTopFlagDetail(StringSplitUtil.idListToString(this.topFlagDetailList));
        return task;
    }
}
