package com.tykj.dev.device.task.subject.domin;

import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.misc.base.BeanHelper;
import com.tykj.dev.misc.utils.StringSplitUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.modelmapper.ModelMapper;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for task
 * 任务详情
*/
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@ApiModel("任务详情")
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update task set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@Table(name = "task",schema = "task")
public class Task {

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty(value = "主键id")
	private Integer id;

	@ApiModelProperty(value = "任务状态")
	private Integer billStatus;

	@ApiModelProperty(value = "任务标题")
	private String title;

	@CreatedBy
	@ApiModelProperty(value = "创建用户id")
	private Integer createUserId;

	@CreatedDate
	@ApiModelProperty(value = "创建时间")
	private Date createTime;

	@LastModifiedBy
	@ApiModelProperty(value = "更新用户id")
	private Integer updateUserId;

	@LastModifiedDate
	@ApiModelProperty(value = "更新时间")
	private Date updateTime;

	@ApiModelProperty(value = "父任务主键id")
	private Integer parentTaskId;

	@ApiModelProperty(value = "所有节点任务id组合,例如.1.2.,意为从根节点到当前节点所经历的节点为1和2")
	private String nodeIdDetail;

	@ApiModelProperty(value = "对应账单ID")
	private Integer billId;

	@ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
	private Integer deleteTag = 0;

	@ApiModelProperty(value = "业务类型主键id")
	private Integer bussinessType;

	@ApiModelProperty(value = "所属单位")
	private Integer ownUnit;

	@ApiModelProperty(value = "用户置顶信息")
	private String topFlagDetail;

	@ApiModelProperty(value = "用户阅读信息")
	private String userReadDetail;

	@ApiModelProperty(value = "数字类型，用于代表指针目前的下标")
	private Integer currentPoint;

	@ApiModelProperty(value = "自定义信息，针对不同业务需要保存一些自定信息")
	private String customInfo;

	@ApiModelProperty(value = "工作涉及人员id(x作为分隔符),例如x1x2x,意为id为1,2的用户参与了该任务")
	private String involveUsers;

	@ApiModelProperty(value = "跟踪时间")
	@Transient
	private String userTime;

	@ApiModelProperty(value = "跟踪时间日期")
	@Transient
	private Date userTimeDate;

	@ApiModelProperty(value = "处理人")
	@Transient
	private String processingUser;

	@ApiModelProperty(value = "待办时间")
	@Transient
	private String trackingTime;

	@ApiModelProperty(value = "待办时间日期")
	@Transient
	private Date trackingTimeDate;

	@ApiModelProperty(value = "发起单位")
	@Transient
	private String startUnit;

	@ApiModelProperty(value = "是否阅读(0:未读，1:已读)")
	@Transient
	private Integer isRead = 0;

	@ApiModelProperty(value = "是否置顶(0:是，1:不是)")
	@Transient
	private Integer isTop = 0;

	@ApiModelProperty(value = "状态描述")
	@Transient
	private String status;

	/**
	 * do类转化为bto类
	 */
	public TaskBto parse2Bto(){
		//modelMap复制
		ModelMapper mapper = BeanHelper.getUserMapper();
		TaskBto taskBto = mapper.map(this,TaskBto.class);
		//解析组合字段并添加
		taskBto.setInvoleUserIdList(StringSplitUtil.userIdSplit(this.involveUsers));
		taskBto.setTopFlagDetailList(StringSplitUtil.userIdSplit(this.topFlagDetail));
		taskBto.setUserReadDetailList(StringSplitUtil.userIdSplit(this.userReadDetail));
		return taskBto;
	}
}
