/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.internal;

import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import java.util.ArrayList;
import java.util.List;

public class OptionGroup {
    private List<Option> options = new ArrayList<Option>();

    public OptionGroup createGroup(Option ... optionArray) {
        OptionGroup optionGroup = new OptionGroup();
        for (Option option : optionArray) {
            optionGroup.addOption(option);
        }
        return optionGroup;
    }

    private void addOption(Option option) {
        this.options.add(option);
    }

    public boolean isValid(ParsedArguments parsedArguments) {
        int n = 0;
        for (Option option : this.options) {
            if (parsedArguments.containsOption(option)) {
                ++n;
            }
            if (n <= 1) continue;
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Only one of the following may be provided: ");
        for (Option option : this.options) {
            if (option.getLongName() != null) {
                stringBuilder.append(String.format("-%s/--%s ", option.getName(), option.getLongName()));
                continue;
            }
            stringBuilder.append(String.format("-%s ", option.getName()));
        }
        return stringBuilder.toString();
    }
}

