/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.device;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.internal.FTP;
import com.zebra.sdk.comm.internal.FtpFileHolder;
import com.zebra.sdk.device.Profile;
import com.zebra.sdk.printer.PrinterAlert;
import com.zebra.sdk.printer.internal.ProfileHelper;
import com.zebra.sdk.settings.SettingsException;
import com.zebra.sdk.settings.internal.AlertsUtilLinkOs;
import com.zebra.sdk.settings.internal.JsonHelper;
import com.zebra.sdk.settings.internal.PrinterlessConnection;
import com.zebra.sdk.util.internal.ZipUtil;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProfileToMirrorServer {
    private String server;
    private String user;
    private String password;
    private final String pathToProfile;

    public ProfileToMirrorServer(String string) throws IOException {
        this.pathToProfile = string;
    }

    public List<String> sendToMirrorServer(String string, String string2, String string3) throws ConnectionException, FileNotFoundException, IOException {
        this.server = string;
        this.user = string2;
        this.password = string3;
        ArrayList<String> arrayList = new ArrayList<String>();
        this.deleteAllFilesOnMirrorServer();
        try {
            Profile profile = new Profile(this.pathToProfile);
            this.loadFirmwareFromProfile(profile);
            byte[] byArray = JsonHelper.buildSetCommand(profile.getClonableSettingValues());
            this.storeFileViaFtp("commands", byArray, "settings.txt");
        }
        catch (SettingsException settingsException) {
            // empty catch block
        }
        try {
            this.loadAlertsFromProfile(this.pathToProfile);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (SettingsException settingsException) {
            // empty catch block
        }
        this.loadFilesFromProfile(this.pathToProfile);
        return arrayList;
    }

    private void loadFirmwareFromProfile(Profile profile) throws ConnectionException, FileNotFoundException, IOException {
        ZipUtil zipUtil;
        InputStream inputStream;
        String string = new String(new ZipUtil(this.pathToProfile).extractEntry("firmwareFileUserSpecifiedName.txt"));
        if (string != null && !string.isEmpty() && (inputStream = (zipUtil = new ZipUtil(this.pathToProfile)).getInputStreamToEntry("firmwareFile.txt")) != null) {
            this.storeFileViaFtp("appl", string, inputStream);
            zipUtil.closeStreams();
        }
    }

    private void loadAlertsFromProfile(String string) throws SettingsException, ConnectionException, FileNotFoundException, IOException {
        List<PrinterAlert> list = ProfileHelper.getAlertsFromJson(string);
        PrinterlessConnection printerlessConnection = new PrinterlessConnection();
        AlertsUtilLinkOs.setAlerts(list, printerlessConnection);
        String string2 = printerlessConnection.getStuffWrittenOnConnection();
        this.storeFileViaFtp("commands", string2.getBytes(), "alerts.txt");
    }

    private void loadFilesFromProfile(String string) throws ConnectionException, FileNotFoundException, IOException {
        ArrayList<FtpFileHolder> arrayList = new ArrayList<FtpFileHolder>();
        ZipUtil zipUtil = new ZipUtil(string);
        List<String> list = zipUtil.getEntryNames();
        for (String string2 : list) {
            if (ProfileHelper.isSpecialProfileFile(string2)) continue;
            byte[] byArray = zipUtil.extractEntry(string2);
            arrayList.add(new FtpFileHolder("commands", string2, new ByteArrayInputStream(byArray)));
        }
        this.storeFilesViaFtp(arrayList);
    }

    protected void storeFileViaFtp(String string, byte[] byArray, String string2) throws ConnectionException {
        FTP fTP = new FTP(this.server, this.user, this.password);
        fTP.putFile(string, string2, byArray);
    }

    protected void storeFileViaFtp(String string, String string2, InputStream inputStream) throws ConnectionException {
        FTP fTP = new FTP(this.server, this.user, this.password);
        fTP.putFile(string, string2, inputStream);
    }

    protected void storeFilesViaFtp(List<FtpFileHolder> list) throws ConnectionException {
        FTP fTP = new FTP(this.server, this.user, this.password);
        fTP.putFiles(list);
    }

    protected void deleteAllFilesOnMirrorServer() throws ConnectionException {
        FTP fTP = new FTP(this.server, this.user, this.password);
        fTP.deleteAllFilesAndSubDirectories(Arrays.asList("appl", "commands", "files"));
    }
}

