/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.internal;

import com.zebra.sdk.util.fileConversion.internal.PrinterFileType;
import com.zebra.sdk.util.fileConversion.internal.PrinterWrappingType;
import com.zebra.sdk.util.internal.ZCRC16;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class PrinterFileMetadata
implements Serializable {
    private static final long serialVersionUID = 8624518581207798813L;
    private long fileSize;
    private String crc16;
    private String checkSum;
    protected String fileName;
    private PrinterWrappingType printerWrappingType = PrinterWrappingType.UNSUPPORTED;
    private PrinterFileType printerFileType = PrinterFileType.UNSUPPORTED;

    public PrinterFileMetadata(long l, String string, String string2) {
        this.init(l, string, string2, null);
    }

    public PrinterFileMetadata(long l, String string, String string2, String string3) {
        this.init(l, string, string2, string3);
    }

    public PrinterFileMetadata(InputStream inputStream) throws IOException {
        char c = '\u0000';
        int n = 0;
        long l = 0L;
        int n2 = inputStream.read();
        while (n2 != -1) {
            n = (char)(n + n2);
            c = ZCRC16.addCrc16Byte_cpcl(c, n2);
            ++l;
            n2 = inputStream.read();
        }
        String string = String.format("%04X", c);
        String string2 = String.format("%04X", (n ^ 0xFFFF) + 1);
        this.init(l, string, string2, null);
    }

    private void init(long l, String string, String string2, String string3) {
        if (l <= 0L || this.isInvalid16BitHex(string) || this.isInvalid16BitHex(string2)) {
            throw new IllegalArgumentException("Could not instantiate a valid file metadata");
        }
        this.fileSize = l;
        this.crc16 = string;
        this.checkSum = string2;
        this.fileName = string3;
    }

    private boolean isInvalid16BitHex(String string) {
        try {
            Integer.parseInt(string, 16);
            if (string.length() == 4) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getCrc16() {
        return this.crc16;
    }

    public String getCheckSum() {
        return this.checkSum;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public PrinterWrappingType getPrinterWrappingType() {
        return this.printerWrappingType;
    }

    public void setPrinterWrappingType(PrinterWrappingType printerWrappingType) {
        this.printerWrappingType = printerWrappingType;
    }

    public PrinterFileType getPrinterFileType() {
        return this.printerFileType;
    }

    public void setPrinterFileType(PrinterFileType printerFileType) {
        this.printerFileType = printerFileType;
    }
}

