package com.tykj.dev.device.apply.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.allot.service.AllotBillService;
import com.tykj.dev.device.allot.subject.domin.AllotBill;
import com.tykj.dev.device.apply.service.DeviceApplyBillService;
import com.tykj.dev.device.apply.subject.domin.DeviceApplyBill;
import com.tykj.dev.device.apply.subject.vo.DeviceApplyAllotSaveVo;
import com.tykj.dev.device.apply.subject.vo.DeviceApplyConfirmVo;
import com.tykj.dev.device.apply.subject.vo.DeviceApplySaveVo;
import com.tykj.dev.device.library.service.DeviceLogService;
import com.tykj.dev.device.library.subject.Dto.DeviceLogDto;
import com.tykj.dev.device.task.service.TaskLogService;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.bto.TaskLogBto;
import com.tykj.dev.device.task.subject.common.StatusEnum;
import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.device.library.subject.vo.FileVo;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.device.user.util.UserUtils;
import com.tykj.dev.misc.utils.ResultUtil;
import com.tykj.dev.misc.utils.StringSplitUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@RestController
@Api(tags = "装备申请模块",description = "申请模块")
@AutoDocument
@RequestMapping("/apply")
public class DeviceApplyController {

    @Autowired
    private DeviceApplyBillService deviceApplyBillService;

    @Autowired
    private UserUtils userUtils;

    @Autowired
    private TaskService taskService;

    @Autowired
    private DeviceLogService deviceLogService;

    @Autowired
    private UserPublicService userPublicService;

    @Autowired
    private AllotBillService allotBillService;

    @Autowired
    private TaskLogService taskLogService;

    @ApiOperation(value = "发起装备申请",notes = "可以通过这个接口发起装备申请")
    @PostMapping("/addDeviceApplyBill")
    public ResponseEntity<DeviceApplyBill> addDeviceApplyBill(@RequestBody DeviceApplySaveVo deviceApplySaveVo){
        //添加申请单
        DeviceApplyBill deviceApplyBillEntity = deviceApplyBillService.addEntity(deviceApplySaveVo.toDo());
        Integer userId = userUtils.getCurrentUserId();
        //发起任务
        TaskBto taskBto;
        if (deviceApplySaveVo.getReplyUseraId()!=null) {
            List<Integer> userIds = new ArrayList<>();
            userIds.add(userId);
            userIds.add(deviceApplySaveVo.getReplyUseraId());
            taskBto = new TaskBto(StatusEnum.DEVICE_APPLY_CONFIRM.id, "申请业务", null, ".", deviceApplyBillEntity.getId(), 9, userPublicService.findUnitIdByName(deviceApplySaveVo.getReplyUnit()), 1, null, userIds);
        }
        else{
            List<Integer> userIds = new ArrayList<>();
            userIds.add(userId);
            userIds.add(0);
            taskBto = new TaskBto(StatusEnum.DEVICE_APPLY_CONFIRM.id, "申请业务", null, ".", deviceApplyBillEntity.getId(), 9, userPublicService.findUnitIdByName(deviceApplySaveVo.getReplyUnit()), 1, null, userIds);
        }
        Task saveEntity = taskService.start(taskBto);
        TaskLogBto taskLogBto = new TaskLogBto(saveEntity.getId(),"发起装备申请",null);
        taskLogService.addLog(taskLogBto);
        return ResultUtil.success(deviceApplyBillEntity);
    }

    @ApiOperation(value = "装备申请批复",notes = "可以通过这个接口批复")
    @PostMapping("/replay")
    public ResponseEntity<TaskBto> addDeviceApplyBillReplay(@RequestBody DeviceApplyConfirmVo deviceApplyConfirmVo){
        TaskBto taskBto = taskService.get(deviceApplyConfirmVo.getTaskId());
        Integer userId = userUtils.getCurrentUserId();
        DeviceApplyBill applyBillEntity = deviceApplyBillService.getOne(taskBto.getBillId());
        if (deviceApplyConfirmVo.getReplyNumber()!=null){
            applyBillEntity.setReplayNumber(deviceApplyConfirmVo.getReplyNumber());
        }
        //批复驳回
        if (deviceApplyConfirmVo.getStatus()==1){
            applyBillEntity.setApplyStatus(1);
            taskService.update(taskService.moveToArchive(taskBto));
            deviceApplyBillService.update(applyBillEntity);
            TaskLogBto taskLogBto = new TaskLogBto(taskBto.getId(),"装备申请批复驳回",null);
            taskLogService.addLog(taskLogBto);
            return ResultUtil.success(taskBto);
        }
        //批复成功
        if (deviceApplyConfirmVo.getStatus()==0){
            applyBillEntity.setApplyStatus(2);
            taskService.update(taskService.moveToEnd(taskBto));
            TaskLogBto taskLogBto = new TaskLogBto(taskBto.getId(),"装备申请批复通过",null);
            taskLogService.addLog(taskLogBto);
            //生成配发子任务
            List<Integer> userIds = new ArrayList<>();
            userIds.add(userId);
            TaskBto taskBto1 = new TaskBto(StatusEnum.WAIT_ALLOT.id, "配发业务", taskBto.getId(), "."+taskBto.getId()+".", 0, 3, userUtils.getCurrentUnitId(), 0, null, userIds);
            Task task = taskService.start(taskBto1);
            deviceApplyBillService.update(applyBillEntity);
            return ResultUtil.success(task.parse2Bto());
        }
        else {
            return ResultUtil.failed();
        }
    }

    @ApiOperation(value = "装备申请后发起配发",notes = "可以通过这个接口装备申请后发起配发")
    @PostMapping("/allot")
    public ResponseEntity<String> allot(@RequestBody DeviceApplyAllotSaveVo deviceApplyAllotSaveVo){
        TaskBto taskBto = taskService.get(deviceApplyAllotSaveVo.getTaskId());
        TaskBto applyTask = taskService.get(taskBto.getParentTaskId());
        Integer userId = userUtils.getCurrentUserId();
        DeviceApplyBill deviceApplyBillEntity = deviceApplyBillService.getOne(applyTask.getBillId());
        AllotBill allotBillEntity = new AllotBill();
        BeanUtils.copyProperties(deviceApplyAllotSaveVo,allotBillEntity);
        allotBillEntity.setTitle("申请后配发");
        allotBillEntity.setSendUseraId(userId);
        allotBillEntity.setReceiveUseraId(applyTask.getCreateUserId());
        allotBillEntity.setApplyNumber(deviceApplyBillEntity.getApplyNumber());
        allotBillEntity.setReplayNumber(deviceApplyBillEntity.getReplayNumber());
        allotBillEntity.setSendUnit(deviceApplyBillEntity.getReplyUnit());
        allotBillEntity.setReceiveUnit(deviceApplyBillEntity.getApplyUnit());
        allotBillEntity.setSendTime(new Date());
        allotBillEntity.setAllotType(2);
        allotBillEntity.setAllotStatus(0);
        AllotBill allotBillEntity1 = allotBillService.addEntity(allotBillEntity);
        taskBto.setBillId(allotBillEntity1.getId());
        taskService.update(taskService.moveToNext(taskBto,deviceApplyAllotSaveVo.getSendUserbId()));
        List<FileVo> fileVoList = new ArrayList<>();
        fileVoList.add(new FileVo("出库确认单",allotBillEntity.getFileName(),allotBillEntity.getFileUrl()));
        TaskLogBto taskLogBto = new TaskLogBto(taskBto.getId(),"对" + allotBillEntity.getReceiveUnit() + "发起配发",fileVoList);
        taskLogService.addLog(taskLogBto);
        List<Integer> integerList = StringSplitUtil.split(allotBillEntity.getAllotCheckDetail());
        if (integerList.size()>0) {
            for (Integer id : integerList) {
                if (id > 0) {
                    DeviceLogDto deviceLogDto = new DeviceLogDto(id,"对" + allotBillEntity.getReceiveUnit() + "发起配发",fileVoList);
                    deviceLogService.addLog(deviceLogDto);
                }
            }
        }
        return ResultUtil.success("发起配发成功");
    }
}
