package com.tykj.dev.device.apply.subject.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for device_apply_bill
 * 申请账单
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update device_apply_bill set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("申请账单")
public class DeviceApplyBill {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty(name = "主键id")
	private Integer id;
	/**
	* 申请文号
	*/
	@ApiModelProperty(value = "申请文号")
	private String applyNumber;
	/**
	* 批复文号
	*/
	@ApiModelProperty(value = "批复文号")
	private String replayNumber;
	/**
	* 申请单位
	*/
	@ApiModelProperty(value = "申请单位")
	private String applyUnit;
	/**
	* 批复单位
	*/
	@ApiModelProperty(value = "批复单位")
	private String replyUnit;
	/**
	 * 经办人
	 */
	@ApiModelProperty(value = "经办人")
	private String agent;
	/**
	 * 配发单id
	 */
	@ApiModelProperty(value = "配发单id")
	private Integer allotId;
	/**
	* 申请方id(A岗位)
	*/
	@ApiModelProperty(value = "申请方id(A岗位)")
	private Integer applyUseraId;
	/**
	* 批复方id(A岗位)
	*/
	@ApiModelProperty(value = "批复方id(A岗位)")
	private Integer replyUseraId;
	/**
	* 申请状态(0:申请待审核,1:申请审核失败,2:申请中,3:已批复待审核,4:批复审核失败,5:申请成功)
	*/
	@ApiModelProperty(value = "申请状态(0:申请待审核,1:申请审核失败,2:申请中,3:驳回,4:申请成功)")
	private Integer applyStatus;
	/**
	* 列装库主键idx数量(,作为分隔符),例如1x2,2x3,意为列装库id为1的申请2件,id为2的申请3件
	*/
	@ApiModelProperty(value = "列装库主键idx数量(,作为分隔符),例如1x2,2x3,意为列装库id为1的申请2件,id为2的申请3件")
	private String applyDetail;
	/**
	* 创建用户id
	*/
	@CreatedBy
	@ApiModelProperty(value = "创建用户id")
	private Integer createUserId;
	/**
	* 创建时间
	*/
	@CreatedDate
	@ApiModelProperty(value = "创建时间")
	private Date createTime;
	/**
	* 更新用户id
	*/
	@LastModifiedBy
	@ApiModelProperty(value = "更新用户id")
	private Integer updateUserId;
	/**
	* 更新时间
	*/
	@LastModifiedDate
	@ApiModelProperty(value = "更新时间")
	private Date updateTime;
	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
	private Integer deleteTag = 0;

	@ApiModelProperty(value = "申请人")
	@Transient
	private String applyUser;
}
