package com.tykj.dev.device.apply.subject.vo;

import com.tykj.dev.device.apply.subject.domin.DeviceApplyBill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("装备申请存储类")
public class DeviceApplySaveVo {

    @ApiModelProperty(value = "申请文号")
    private String applyNumber;

    @ApiModelProperty(value = "批复文号")
    private String replayNumber;

    @ApiModelProperty(value = "申请单位")
    private String applyUnit;

    @ApiModelProperty(value = "批复单位")
    private String replyUnit;

    @ApiModelProperty(value = "经办人")
    private String agent;

    @ApiModelProperty(value = "申请人id")
    private Integer applyUseraId;

    @ApiModelProperty(value = "批复人id")
    private Integer replyUseraId;

    @ApiModelProperty(value = "入库列装数量详情")
    private List<ApplyBillDetailVo> storageBillDetailVoList;

    public DeviceApplyBill toDo(){
        DeviceApplyBill deviceApplyBillEntity = new DeviceApplyBill();
        BeanUtils.copyProperties(this,deviceApplyBillEntity);
        deviceApplyBillEntity.setApplyStatus(0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("x");
        if (this.storageBillDetailVoList.size()>0){
            for (ApplyBillDetailVo s:storageBillDetailVoList) {
                stringBuffer.append(s.getPackingId()).append("x");
                stringBuffer.append(s.getStorageCount()).append("x");
            }
        }
        deviceApplyBillEntity.setApplyDetail(stringBuffer.toString());
        return deviceApplyBillEntity;
    }

}
