package com.tykj.dev.device.library.subject.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for device_use_report
 * 装备使用报告
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update device_use_report set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("装备使用报告")
public class DeviceUseReport {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty(name = "主键id")
	private Integer id;
	/**
	* 报告标题
	*/
	@ApiModelProperty(value = "报告标题")
	private String title;
	/**
	* 报告所属单位
	*/
	@ApiModelProperty(value = "报告所属单位")
	private String unit;
	/**
	* 报告详情(入库数x退回数x退装数x维修数x销毁数x配发数x列装数)
	*/
	@ApiModelProperty(value = "报告详情(入库数x退回数x退装数x维修数x销毁数x配发数x列装数)")
	private String reportDetail;
	/**
	* 创建用户id
	*/
	@CreatedBy
	@ApiModelProperty(value = "创建用户id")
	private Integer createUserId;
	/**
	* 创建时间
	*/
	@CreatedDate
	@ApiModelProperty(value = "创建时间")
	private Date createTime;
	/**
	* 更新用户id
	*/
	@LastModifiedBy
	@ApiModelProperty(value = "更新用户id")
	private Integer updateUserId;
	/**
	* 更新时间
	*/
	@LastModifiedDate
	@ApiModelProperty(value = "更新时间")
	private Date updateTime;
	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
	private Integer deleteTag = 0;

}
