package com.tykj.dev.device.packing.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.stereotype.Repository;

/**
 * @author dengdiyi
 */
@Repository
@Data
@ApiModel("列装更新类")
public class PackingLibraryUpdateVo {

    @ApiModelProperty(value = "列装库id",example = "1")
    private int packingId;

    @ApiModelProperty(value = "型号",example = "测试型号")
    private String model;

    @ApiModelProperty(value = "名称",example = "测试名称")
    private String name;

    @ApiModelProperty(value = "应用类型",example = "1")
    private Integer applyType;

    @ApiModelProperty(value = "密级",example = "1")
    private Integer secretLevel;

    @ApiModelProperty(value = "配用范围",example = "1")
    private Integer matchingRange;

    @ApiModelProperty(value = "可见范围",example = "1")
    private Integer invisibleRange;

    @ApiModelProperty(value = "类型",example = "1")
    private Integer type;

    @ApiModelProperty(value = "列装状态",example = "1")
    private Integer status;

    @ApiModelProperty(value = "列装性质",example = "1")
    private Integer nature;

    @ApiModelProperty(value = "生产单位",example = "测试型号")
    private String prodUnit;

    @ApiModelProperty(value = "创建单位",example = "测试创建单位")
    private String createUnit;

    @ApiModelProperty(value = "价格",example = "2.000.000")
    private String price;

    @ApiModelProperty(value = "照片名称",example = "没有先填一个空格")
    private String imageName;

    @ApiModelProperty(value = "照片路径",example = "没有先填一个空格")
    private String imageUrl;

    @ApiModelProperty(value = "附件名称",example = "没有先填一个空格")
    private String fileName;

    @ApiModelProperty(value = "附件路径",example = "没有先填一个空格")
    private String fileUrl;

}
