package com.tykj.dev.device.retired.service.Impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.retired.entity.domain.DeviceRetiredBill;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.tykj.dev.device.retired.repository.DeviceRetiredBillDao;
import com.tykj.dev.device.retired.service.DeviceRetiredBillService;

import java.util.Optional;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class DeviceRetiredBillServiceImpl
 * @packageName com.tykj.dev.device.retired.subject.service
 **/
@Service
public class DeviceRetiredBillServiceImpl implements DeviceRetiredBillService {

    @Autowired
    DeviceRetiredBillDao deviceRetiredBillDao;

    @Autowired
    DeviceLibraryDao deviceLibraryDao;

    @Override
    public DeviceRetiredBill addEntity(DeviceRetiredBill deviceRetiredBillEntity) {
        return deviceRetiredBillDao.save(deviceRetiredBillEntity);
    }


    @Override
    public DeviceRetiredBill getOne(Integer id) {
        Optional<DeviceRetiredBill> resultEntity = deviceRetiredBillDao.findById(id);
        return resultEntity.orElse(null);
    }

    @Override
    public DeviceRetiredBill update(DeviceRetiredBill deviceRetiredBillEntity) {
        return deviceRetiredBillDao.save(deviceRetiredBillEntity);
    }

    @Override
    public void delete(Integer id) {
        deviceRetiredBillDao.deleteById(id);
    }

    @Override
    public Long getCantPackingCount(Integer packingLibraryId) {
        PredicateBuilder<DeviceLibrary> predicateBuilder = Specifications.and();
        predicateBuilder.notIn("lifeStatus",10,13);
        predicateBuilder.eq("packingId",packingLibraryId);
        return deviceLibraryDao.count(predicateBuilder.build());
    }


}
