package com.tykj.dev.device.task.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.library.repository.DeviceLogDao;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.vo.TaskSelectVo;
import com.tykj.dev.device.task.subject.vo.TaskUserVo;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.device.user.util.UserUtils;
import com.tykj.dev.misc.utils.ResultUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author dengdiyi
 */
@RestController
@Api(tags = "业务模块",description = "业务模块")
@AutoDocument
@RequestMapping("/business")
public class TaskController {

    @Autowired
    private TaskService taskService;

    @Autowired
    private UserUtils userUtils;

    @Autowired
    private DeviceLibraryService deviceLibraryService;

    @Autowired
    private UserPublicService userPublicService;

    @Autowired
    private DeviceLogDao deviceLogDao;

//    @ApiOperation(value = "业务分页查询",notes = "可以通过这个接口分页查询业务")
//    @RequestMapping(method = RequestMethod.POST , value = "/manage/summary",produces = MediaType.APPLICATION_JSON_VALUE)
//    public ResultObj getTaskPage(@RequestBody TaskSelectVo taskSelectVo){
//        List<TaskEntity> taskServicePage = taskService.getPage(taskSelectVo, taskSelectVo.getPageable());
//        List<TaskEntity> list = new ArrayList<>();
//        List<TaskEntity> list1 = new ArrayList<>();
//        List<TaskEntity> list2 = new ArrayList<>();
//        for (TaskEntity t:taskServicePage) {
//            if (t.getIsTop()==1){
//                list1.add(t);
//            }
//        }
//        for (TaskEntity t:list1) {
//            if (t.getIsRead()==0){
//                list.add(t);
//            }
//        }
//        for (TaskEntity t:list1) {
//            if (t.getIsRead()==1){
//                list.add(t);
//            }
//        }
//        for (TaskEntity t:taskServicePage) {
//            if (t.getIsTop()==0){
//                list2.add(t);
//            }
//        }
//        for (TaskEntity t:list2) {
//            if (t.getIsRead()==0){
//                list.add(t);
//            }
//        }
//        for (TaskEntity t:list2) {
//            if (t.getIsRead()==1){
//                list.add(t);
//            }
//        }
//        if (list.size()<=taskSelectVo.getSize()) {
//            return new ResultObj(new PageImpl<>(list, taskSelectVo.getPageable(), list.size()),"查询成功");
//        }
//        else {
//            Double d = Math.ceil(list.size()/taskSelectVo.getSize().doubleValue());
//            int value = new Double(d).intValue();
//            if (taskSelectVo.getPage()>=value){
//                return null;
//            }
//            else {
//                int index = taskSelectVo.getPage()*taskSelectVo.getSize();
//                if (taskSelectVo.getPage()==value){
//                    return new ResultObj(new PageImpl<>(list.subList(index,list.size()), taskSelectVo.getPageable(), list.size()),"查询成功");
//                }
//                return new ResultObj(new PageImpl<>(list.subList(index,index+taskSelectVo.getSize()), taskSelectVo.getPageable(), list.size()),"查询成功");
//            }
//        }
//    }

    @ApiOperation(value = "业务跟踪待办列表查询",notes = "可以通过这个接口查询业务")
    @RequestMapping(method = RequestMethod.POST , value = "/getTaskList",produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<List<TaskUserVo>> getTaskList(@RequestBody TaskSelectVo taskSelectVo){
        List<TaskUserVo> taskEntities = taskService.getList(taskSelectVo);
        //按置顶第一顺序，未读第二顺序排序输出
        List<TaskUserVo> list = new ArrayList<>();
        List<TaskUserVo> list1 = new ArrayList<>();
        List<TaskUserVo> list2 = new ArrayList<>();
        //将置顶筛选到list1
        for (TaskUserVo t:taskEntities) {
            if (t.getIsTop()==1){
                list1.add(t);
            }
        }
        //list1中将未读的放在list最前面
        for (TaskUserVo t:list1) {
            if (t.getIsRead()==0){
                list.add(t);
            }
        }
        //list1中将已读的放在list最后面
        for (TaskUserVo t:list1) {
            if (t.getIsRead()==1){
                list.add(t);
            }
        }
        //将未置顶的放入list2中
        for (TaskUserVo t:taskEntities) {
            if (t.getIsTop()==0){
                list2.add(t);
            }
        }
        //将未读的优先放入list中
        for (TaskUserVo t:list2) {
            if (t.getIsRead()==0){
                list.add(t);
            }
        }
        //将已读的放入list
        for (TaskUserVo t:list2) {
            if (t.getIsRead()==1){
                list.add(t);
            }
        }
        return ResultUtil.success(list);
    }

//    @ApiOperation(value = "置顶设置",notes = "可以通过这个接口置顶业务")
//    @RequestMapping(method = RequestMethod.PUT , value = "/setTop",produces = MediaType.APPLICATION_JSON_VALUE)
//    public ResultObj setTop(@RequestBody TaskTopVo taskTopVo){
//        TaskEntity taskEntity = taskService.getOne(taskTopVo.getTaskId());
//        Integer userId = userUtils.getCurrentUserId();
//        if (taskTopVo.getTopFlag()==1) {
//            if (taskEntity.getTopFlagDetail()!=null) {
//                taskEntity.setTopFlagDetail(taskEntity.getTopFlagDetail() + userId + "x");
//            }
//            else {
//                taskEntity.setTopFlagDetail("x" + userId + "x");
//            }
//        }
//        if (taskTopVo.getTopFlag()==0){
//            List<Integer> idList = StringSplitUtil.userIdSplit(taskEntity.getTopFlagDetail());
//            StringBuffer stringBuffer = new StringBuffer();
//            stringBuffer.append("x");
//            if (idList.size()>0){
//                for (Integer id:idList) {
//                    if (!id.equals(userId)){
//                        stringBuffer.append(id+"x");
//                    }
//                }
//            }
//            taskEntity.setTopFlagDetail(stringBuffer.toString());
//        }
//        TaskEntity taskEntityUpdated = taskService.update(taskEntity);
//        return new ResultObj(taskEntityUpdated,"修改置顶标志成功");
//    }
//
//    @ApiOperation(value = "是否已读设置",notes = "可以通过这个接口设置业务的是否已读")
//    @PostMapping("/setRead")
//    public ResultObj setRead(@RequestBody TaskTopVo taskTopVo){
//        TaskEntity taskEntity = taskService.getOne(taskTopVo.getTaskId());
//        Integer userId = userUtils.getCurrentUserId();
//        if (taskTopVo.getTopFlag()==1) {
//            if (taskEntity.getUserReadDetail()!=null) {
//                taskEntity.setUserReadDetail(taskEntity.getUserReadDetail() + userId + "x");
//            }
//            else {
//                taskEntity.setUserReadDetail("x" + userId + "x");
//            }
//        }
//        if (taskTopVo.getTopFlag()==0){
//            List<Integer> idList = StringSplitUtil.userIdSplit(taskEntity.getUserReadDetail());
//            StringBuffer stringBuffer = new StringBuffer();
//            stringBuffer.append("x");
//            if (idList.size()>0){
//                for (Integer id:idList) {
//                    if (!id.equals(userId)){
//                        stringBuffer.append(id+"x");
//                    }
//                }
//            }
//            taskEntity.setUserReadDetail(stringBuffer.toString());
//        }
//        TaskEntity taskEntityUpdated = taskService.update(taskEntity);
//        return new ResultObj(taskEntityUpdated,"修改阅读标志成功");
//    }

//    @ApiOperation(value = "查询业务对应页面的数据",notes = "可以通过这个接口查询业务对应页面的数据")
//    @GetMapping("/manage/detail/{id}")
//    public ResultObj selectData(@PathVariable("id") int taskId){
//        TaskEntity taskEntity = taskService.getOne(taskId);
//        taskEntity.setJobId(taskUtils.getCurrentJob(taskId).getId());
//        Integer bussinessType = taskEntity.getBussinessType();
//        Integer billId = taskEntity.getBillId();
//        List<Object> list = new ArrayList<>();
//        list.add(taskEntity);
//        switch (bussinessType){
//            case 1:
//                PackingLibraryEntity packingLibraryEntity = packingLibraryService.getOne(billId);
//                packingLibraryEntity.setUserA(userPublicService.getOne(packingLibraryEntity.getUserAId()).getName());
//                packingLibraryEntity.setUserB(userPublicService.getOne(packingLibraryEntity.getUserBId()).getName());
//                list.add(packingLibraryEntity);
//                List<PackingLibraryEntity> packingLibraryEntities= packingLibraryService.selectAllPart(billId);
//                list.add(packingLibraryEntities);
//                return new ResultObj(list,"查询成功");
//            case 2:
//                StorageBillEntity storageBillEntity = storageBillService.getOne(billId);
//                storageBillEntity.setReceiveUserA(userPublicService.getOne(storageBillEntity.getReceiveUserAId()).getName());
//                storageBillEntity.setReceiveUserB(userPublicService.getOne(storageBillEntity.getReceiveUserBId()).getName());
//                list.add(storageBillEntity);
//                String str = storageBillEntity.getStorageDetail();
//                List<Integer> list1= StringSplitUtil.userIdSplit(str);
//                List<DeviceLibraryEntity> libraryEntities = new ArrayList<>();
//                for (Integer id:list1) {
//                    DeviceLibraryEntity deviceLibraryEntity = deviceLibraryService.getOne(id);
//                    libraryEntities.add(deviceLibraryEntity);
//                }
//                list.add(libraryEntities);
//                return new ResultObj(list,"查询成功");
//            case 3:
//                if (taskEntity.getBillId()==0){
//                    TaskEntity applyTask = taskService.getOne(taskEntity.getParentTaskId());
//                    DeviceApplyBillEntity deviceApplyBillEntity = deviceApplyBillService.getOne(applyTask.getBillId());
//                    List<Integer> idList = StringSplitUtil.userIdSplit(deviceApplyBillEntity.getApplyDetail());
//                    List<Integer> packingIdList = new ArrayList<>();
//                    List<Integer> numList = new ArrayList<>();
//                    List<PackingLibraryEntity> packingLibraryEntityList = new ArrayList<>();
//                    if (idList.size()>0){
//                        for (int i=1;i<=idList.size();i++) {
//                            if (i%2==1){
//                                packingIdList.add(idList.get(i-1));
//                            }
//                            else {
//                                numList.add(idList.get(i-1));
//                            }
//                        }
//                    }
//                    if (packingIdList.size()==numList.size()){
//                        for (int i=0;i<packingIdList.size();i++) {
//                            PackingLibraryEntity p = packingLibraryService.getOne(packingIdList.get(i));
//                            p.setApplyNum(numList.get(i));
//                            packingLibraryEntityList.add(p);
//                        }
//                    }
//                    list.add(packingLibraryEntityList);
//                    //查询可配发相同类型装备列表
//                    list.add(deviceLibraryService.getAllotPage(new DeviceLibrarySelectVo()).stream().filter(deviceLibraryEntity -> packingIdList.contains(deviceLibraryEntity.getPackingId())).sorted(Comparator.comparing(DeviceLibraryEntity::getPackingId)).collect(Collectors.toList()));
//                    return new ResultObj(list,"查询成功");
//                }
//                AllotBillEntity allotBillEntity = allotBillService.getOne(billId);
//                allotBillEntity.setSenderUserA(userPublicService.getOne(allotBillEntity.getSendUserAId()).getName());
//                allotBillEntity.setSenderUserB(userPublicService.getOne(allotBillEntity.getSendUserBId()).getName());
//                allotBillEntity.setReceiveUserA(userPublicService.getOne(allotBillEntity.getReceiveUserAId()).getName());
//                Date date = allotBillEntity.getCreateTime();
//                int year = date.getYear()+1900;
//                String s1 ="NO:第"+year+"PF"+allotBillEntity.getId()+"号";
//                allotBillEntity.setNum(s1);
//                if (allotBillEntity.getReceiveUserBId()!=null){
//                    allotBillEntity.setReceiveUserB(userPublicService.getOne(allotBillEntity.getReceiveUserBId()).getName());
//                }
//                list.add(allotBillEntity);
//                String str2 = allotBillEntity.getAllotCheckDetail();
//                String[] strings1 = str2.split("x");
//                List<DeviceLibraryEntity> deviceLibraryEntities = new ArrayList<>();
//                for (String s:strings1) {
//                    if (s.length()>=2&& "1".equals(s.substring(s.length()-1))) {
//                        Integer id = Integer.parseInt(s.substring(0, s.length() - 1));
//                        Integer checkResult = Integer.parseInt(s.substring(s.length()-1));
//                        DeviceLibraryEntity deviceLibraryEntity = deviceLibraryService.getOne(id);
//                        deviceLibraryEntity.setCheckResult(checkResult);
//                        deviceLibraryEntities.add(deviceLibraryEntity);
//                    }
//                }
//                list.add(deviceLibraryEntities);
//                return new ResultObj(list,"查询成功");
//            case 4:
//                SelfExaminationBillEntity selfExaminationBillEntity = selfExaminationBillService.getOne(billId);
//                if (selfExaminationBillEntity.getUserAId()!=0) {
//                    selfExaminationBillEntity.setCheckUser(userPublicService.getOne(selfExaminationBillEntity.getUserAId()).getName());
//                }
//                if (selfExaminationBillEntity.getUserBId()!=0) {
//                    selfExaminationBillEntity.setConfirmUser(userPublicService.getOne(selfExaminationBillEntity.getUserBId()).getName());
//                }
//                list.add(selfExaminationBillEntity);
//                String str3 = selfExaminationBillEntity.getCheckDetail();
//                String str4 = selfExaminationBillEntity.getNewDeviceDetail();
//                String[] split = str3.split("x");
//                if (str4!=null) {
//                    String[] split2 = str4.split("\\.");
//                    List<DeviceLibraryEntity> newDeviceList = new ArrayList<>();
//                    for (String rfid:split2){
//                        if (rfid.length()>0){
//                            DeviceLibraryEntity d = new DeviceLibraryEntity();
//                            d.setCheckResult(2);
//                            d.setSeqNumber("-");
//                            d.setName("-");
//                            d.setType(0);
//                            d.setRfidSurfaceId("-");
//                            d.setProdNumber("-");
//                            d.setRfidCardId(rfid);
//                            newDeviceList.add(d);
//                        }
//                    }
//                    list.add(newDeviceList);
//                }
//                if (str4==null){
//                    List<DeviceLibraryEntity> newDeviceList = new ArrayList<>();
//                    list.add(newDeviceList);
//                }
//                List<DeviceLibraryEntity> libraryEntities1 = new ArrayList<>();
//                for (String s:split) {
//                    if (s.length()>=2) {
//                        Integer id = Integer.parseInt(s.substring(0, s.length() - 1));
//                        Integer checkResult = Integer.parseInt(s.substring(s.length()-1));
//                        DeviceLibraryEntity deviceLibraryEntity = deviceLibraryService.getOne(id);
//                        deviceLibraryEntity.setCheckResult(checkResult);
//                        libraryEntities1.add(deviceLibraryEntity);
//                    }
//                }
//                list.add(libraryEntities1);
//                return new ResultObj(list,"查询成功");
//            case 19:
//                MatchingDeviceBillEntity matchingDeviceBillEntity = matchingDeviceBillService.getOne(billId);
//                list.add(matchingDeviceBillEntity);
//                List<Integer> integerList = StringSplitUtil.userIdSplit(matchingDeviceBillEntity.getDeviceDetail());
//                List<MatchingDeviceLibraryEntity> matchingDeviceLibraryEntities = new ArrayList<>();
//                if (integerList.size()>0){
//                    for (Integer id:integerList) {
//                        if (id>0){
//                            matchingDeviceLibraryEntities.add(matchingDeviceLibraryService.getOne(id));
//                        }
//                    }
//                }
//                list.add(matchingDeviceLibraryEntities);
//                return new ResultObj(list,"查询成功");
//            case 9:
//                DeviceApplyBillEntity deviceApplyBillEntity = deviceApplyBillService.getOne(taskEntity.getBillId());
//                deviceApplyBillEntity.setApplyUser(userPublicService.getOne(deviceApplyBillEntity.getApplyUserAId()).getName());
//                list.add(deviceApplyBillEntity);
//                List<Integer> idList = StringSplitUtil.userIdSplit(deviceApplyBillEntity.getApplyDetail());
//                List<Integer> packingIdList = new ArrayList<>();
//                List<Integer> numList = new ArrayList<>();
//                List<PackingLibraryEntity> packingLibraryEntityList = new ArrayList<>();
//                if (idList.size()>0){
//                    for (int i=1;i<=idList.size();i++) {
//                        if (i%2==1){
//                            packingIdList.add(idList.get(i-1));
//                        }
//                        else {
//                            numList.add(idList.get(i-1));
//                        }
//                    }
//                }
//                if (packingIdList.size()==numList.size()){
//                    for (int i=0;i<packingIdList.size();i++) {
//                        PackingLibraryEntity p = packingLibraryService.getOne(packingIdList.get(i));
//                        p.setApplyNum(numList.get(i));
//                        packingLibraryEntityList.add(p);
//                    }
//                }
//                list.add(packingLibraryEntityList);
//                list.add(deviceLibraryService.getAllotPage(new DeviceLibrarySelectVo()).stream().filter(deviceLibraryEntity -> packingIdList.contains(deviceLibraryEntity.getPackingId())).sorted(Comparator.comparing(DeviceLibraryEntity::getPackingId)).collect(Collectors.toList()));
//                return new ResultObj(list,"查询成功");
//            default: return null;
//        }
//    }
//
//    private List<DeviceLogEntity> orderByTime(List<DeviceLogEntity> list){
//        Collections.sort(list, (o1, o2) -> {
//            int flag = o1.getLogTime().compareTo(o2.getLogTime());
//            return flag;
//        });
//        return list;
//    }
//
//    @ApiOperation(value = "查询业务日志",notes = "可以通过这个接口查询查询业务日志")
//    @GetMapping("/manage/detail/log/{id}")
//    public ResultObj selectLog(@PathVariable("id") int taskId){
//        Set<String> remarkList = new HashSet<>();
//        List<DeviceLogEntity> deviceLogEntities = new ArrayList<>();
//        List<DeviceLogEntity> logEntities = orderByTime(deviceLogDao.getAllByTaskId(taskId));
//        if (logEntities.size()>0){
//            logEntities.forEach(deviceLogEntity -> {
//                if (!remarkList.contains(deviceLogEntity.getRemark())){
//                    deviceLogEntities.add(deviceLogEntity);
//                    remarkList.add(deviceLogEntity.getRemark());
//                }
//            });
//        }
//        for (DeviceLogEntity d:deviceLogEntities) {
//            d.setUser(userPublicService.getOne(d.getUserId()).getName());
//            d.setUnit(userPublicService.findUnitsNameByUserId(d.getUserId()));
//            String[] strings = d.getFileDetail().split("Ǵ");
//            List<FileVo> fileVos = new ArrayList<>();
//            if (strings.length>0){
//                for (String s:strings) {
//                    if (s.length()>0){
//                        String[] strings1 = s.split("Ǒ");
//                        if ("".equals(strings1[0])&&strings1.length==4){
//                            FileVo fileVo = new FileVo();
//                            fileVo.setFileName(strings1[1]);
//                            fileVo.setFileUrl(strings1[2]);
//                            fileVo.setTitle(strings1[3]);
//                            fileVos.add(fileVo);
//                        }
//                        if (!"".equals(strings1[0])&&strings1.length==3){
//                            FileVo fileVo = new FileVo();
//                            fileVo.setFileName(strings1[0]);
//                            fileVo.setFileUrl(strings1[1]);
//                            fileVo.setTitle(strings1[2]);
//                            fileVos.add(fileVo);
//                        }
//                    }
//                }
//            }
//            d.setFileVoList(fileVos);
//        }
//        return new ResultObj(deviceLogEntities,"查询成功");
//    }
}
