package com.tykj.dev.device.task.service.impl;

import com.tykj.dev.device.task.repository.TaskLogDao;
import com.tykj.dev.device.task.service.TaskLogService;
import com.tykj.dev.device.task.subject.bto.TaskLogBto;
import com.tykj.dev.device.task.subject.domin.TaskLog;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.ResultUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Optional;


/**
 * @author dengdiyi
 */
@Service
public class TaskLogServiceImpl implements TaskLogService {

    @Autowired
    private TaskLogDao taskLogDao;

    @Override
    public TaskLogBto addLog(TaskLogBto taskLogBto) {
        TaskLog taskLog = taskLogBto.toDo();
        return taskLogDao.save(taskLog).parse2bto();
    }

    @Override
    public TaskLogBto getOne(Integer id) {
        Optional<TaskLog> taskLog = taskLogDao.findById(id);
        if (taskLog.isPresent()){
            return taskLog.get().parse2bto();
        }
        else {
            throw new ApiException(ResultUtil.failed("查询的id不存在"));
        }
    }

}
