package com.tykj.dev.device.task.subject.bto;

import com.tykj.dev.device.task.subject.domin.TaskLog;
import com.tykj.dev.device.library.subject.vo.FileVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TaskLogBto {

    @ApiModelProperty(name = "主键id")
    private Integer id;

    @ApiModelProperty(value = "业务id")
    private Integer taskId;

    @ApiModelProperty(value = "操作描述")
    private String remark;

    @ApiModelProperty(value = "附件信息")
    private List<FileVo> fileVoList;

    @ApiModelProperty(value = "操作人")
    private Integer createUserId;

    @ApiModelProperty(value = "操作时间")
    private Date createTime;

    /**
     * dto类转化为do类
     */
    public TaskLog toDo(){
        TaskLog taskLog = new TaskLog();
        taskLog.setTaskId(this.taskId);
        taskLog.setRemark(this.remark);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Ǵ");
        if (this.fileVoList!=null&&this.fileVoList.size()>0) {
            for (FileVo f : this.fileVoList) {
                stringBuffer.append(f.getFileName());
                stringBuffer.append("Ǒ");
                stringBuffer.append(f.getFileUrl());
                stringBuffer.append("Ǒ");
                stringBuffer.append(f.getTitle());
                stringBuffer.append("Ǵ");
            }
        }
        taskLog.setFileDetail(stringBuffer.toString());
        return taskLog;
    }

    public TaskLogBto(Integer taskId, String remark, List<FileVo> fileVoList) {
        this.taskId = taskId;
        this.remark = remark;
        this.fileVoList = fileVoList;
    }
}
