package com.tykj.dev.device.task.subject.common;

import lombok.AllArgsConstructor;

/**
 * @author dengdiyi
 * 业务状态枚举
 */

@AllArgsConstructor
public enum StatusEnum {



    /**
     * RFID标签制作
     */
    CREATE_RFID_BUSINESS(8100,"标签制作业务开始"),
    RFID_BUSINESS_NEED_CONFIRM(8101,"等待审核"),
    RFID_BUSINESS_CONFIRM_FINISH_SUCCESS(8102,"审核成功"),
    RFID_BUSINESS_CONFIRM_FINISH_FAILED(8103,"审核失败"),

    /**
     * 销毁业务
     */
    CREATE_DESTROY_BUSINESS(8110,"标签制作业务开始"),
    DESTROY_BUSINESS_NEED_CONFIRM(8111,"等待审核"),
    DESTROY_BUSINESS_CONFIRM_FINISH_SUCCESS(8112,"审核成功"),
    DESTROY_BUSINESS_CONFIRM_FINISH_FAILED(8113,"审核失败"),

    /**
     * 退装业务
     */
    CREATE_RETIRED_BUSINESS(8120,"标签制作业务开始"),
    RETIRED_BUSINESS_NEED_CONFIRM(8121,"等待审核"),
    RETIRED_BUSINESS_CONFIRM_FINISH_SUCCESS(8122,"审核成功"),
    RETIRED_BUSINESS_CONFIRM_FINISH_FAILED(8123,"审核失败"),


    /**
     * 业务完结
     */
    END(9999,"业务完结"),

    /**
     * 业务封存
     */
    ARCHIVE(8888,"业务封存"),

    /**
     * 列装待审核
     */
    PACKING_CONFIRM(100,"列装待审核"),

    /**
     * 入库待审核
     */
    STORAGE_CONFIRM(200,"入库待审核"),

    /**
     * 待配发
     */
    WAIT_ALLOT(300,"待配发"),

    /**
     * 配发出库待审核
     */
    ALLOT_SEND_CONFIRM(301,"配发出库待审核"),

    /**
     * 配发中
     */
    ALLOTING(302,"配发中"),

    /**
     * 配发入库待审核
     */
    ALLOT_RECEIVE_CONFIRM(303,"配发入库待审核"),

    /**
     * 待自查
     */
    WAIT_SELF_CHECK(400,"待自查"),

    /**
     * 自查待审核
     */
    SELF_CHECK_CONFIRM(401,"自查待审核"),

    /**
     * 装备申请待批复
     */
    DEVICE_APPLY_CONFIRM(500,"装备申请待批复"),
    ;

    public Integer id;

    public String name;
}
