package com.tykj.dev.device.task.subject.domin;

import com.tykj.dev.device.task.subject.bto.TaskLogBto;
import com.tykj.dev.device.library.subject.vo.FileVo;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.modelmapper.ModelMapper;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * entity class for device_log
 * 设备履历日志
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update task_log set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("业务履历日志")
public class TaskLog {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty(name = "主键id")
	private Integer id;
	/**
	* 业务id
	*/
	@ApiModelProperty(value = "业务id")
	private Integer taskId;
	/**
	* 操作描述
	*/
	@ApiModelProperty(value = "操作描述")
	private String remark;
	/**
	* 相关附件信息(Ǵ作为每个附件分隔符,Ǒ作为附件内部分隔符,例如name1Ǒurl1Ǒ配发单Ǵname2Ǒurl2Ǒ入库确认单Ǵ)
	*/
	@ApiModelProperty(value = "相关附件信息(Ǵ作为每个附件分隔符,Ǒ作为附件内部分隔符,例如name1Ǒurl1Ǒ配发单Ǵname2Ǒurl2Ǒ入库确认单Ǵ)")
	private String fileDetail;
	/**
	* 创建用户id
	*/
	@ApiModelProperty(value = "创建用户id")
	@CreatedBy
	private Integer createUserId;
	/**
	* 创建时间
	*/
	@ApiModelProperty(value = "创建时间")
	@CreatedDate
	private Date createTime;
	/**
	* 更新用户id
	*/
	@ApiModelProperty(value = "更新用户id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* 更新时间
	*/
	@ApiModelProperty(value = "更新时间")
	@LastModifiedDate
	private Date updateTime;
	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
	private Integer deleteTag = 0;

	@ApiModelProperty(value = "操作用户")
	@Transient
	private String user;

	@ApiModelProperty(value = "操作单位")
	@Transient
	private String unit;

	@ApiModelProperty(value = "附件信息")
	@Transient
	private List<FileVo> fileVoList;

	/**
	 * do类转化为bto类
	 */
	public TaskLogBto parse2bto(){
		//modelMap复制
		ModelMapper mapper = BeanHelper.getUserMapper();
		TaskLogBto taskLogBto = mapper.map(this,TaskLogBto.class);
		//解析组合字段并添加
		String[] strings = this.fileDetail.split("Ǵ");
		List<FileVo> fileVos = new ArrayList<>();
		if (strings.length>0){
			for (String s:strings) {
				if (s.length()>0){
					String[] strings1 = s.split("Ǒ");
					if ("".equals(strings1[0])&&strings1.length==4){
						FileVo fileVo = new FileVo();
						fileVo.setFileName(strings1[1]);
						fileVo.setFileUrl(strings1[2]);
						fileVo.setTitle(strings1[3]);
						fileVos.add(fileVo);
					}
					if (!"".equals(strings1[0])&&strings1.length==3){
						FileVo fileVo = new FileVo();
						fileVo.setFileName(strings1[0]);
						fileVo.setFileUrl(strings1[1]);
						fileVo.setTitle(strings1[2]);
						fileVos.add(fileVo);
					}
				}
			}
		}
		taskLogBto.setFileVoList(fileVos);
		return taskLogBto;
	}

}
