package com.tykj.dev.device.task.utils;

import com.tykj.dev.device.task.subject.domin.TaskLog;
import com.tykj.dev.device.task.subject.vo.TaskUserVo;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;

/**
 * @author dengdiyi
 * task工具类
 */
@Component
public class TaskUtils {

    /**
     * @param list 业务日志list
     * 按照日志创建时间降序排列
     */
    public List<TaskLog> orderByCreateTimeDesc(List<TaskLog> list){
        Collections.sort(list, (o1, o2) -> {
            int flag = o2.getCreateTime().compareTo(o1.getCreateTime());
            return flag;
        });
        return list;
    }

    /**
     * @param list taskUserVo list
     * 按照跟踪时间增序排列
     */
    public List<TaskUserVo> orderByUserTimeDateAsc(List<TaskUserVo> list){
        Collections.sort(list, (o1, o2) -> {
            int flag = o1.getUserTimeDate().compareTo(o2.getUserTimeDate());
            return flag;
        });
        return list;
    }

    /**
     * @param list taskUserVo list
     * 按照跟踪时间降序排列
     */
    public List<TaskUserVo> orderByUserTimeDateDesc(List<TaskUserVo> list){
        Collections.sort(list, (o1, o2) -> {
            int flag = o2.getUserTimeDate().compareTo(o1.getUserTimeDate());
            return flag;
        });
        return list;
    }

    /**
     * @param list taskUserVo list
     * 按照待办时间增序排列
     */
    public List<TaskUserVo> orderByTrackingTimeDateAsc(List<TaskUserVo> list){
        Collections.sort(list, (o1, o2) -> {
            int flag = o1.getTrackingTimeDate().compareTo(o2.getTrackingTimeDate());
            return flag;
        });
        return list;
    }

    /**
     * @param list taskUserVo list
     * 按照待办时间降序排列
     */
    public List<TaskUserVo> orderByTrackingTimeDateDesc(List<TaskUserVo> list){
        Collections.sort(list, (o1, o2) -> {
            int flag = o2.getTrackingTimeDate().compareTo(o1.getTrackingTimeDate());
            return flag;
        });
        return list;
    }
}
