package com.tykj.dev.device.user.base.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName loginUser.java
 * @Description 登入接口参数对象
 * @createTime 2020年07月28日 10:33:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "登入接口参数对象", description = "登入接口参数信息")
public class LoginUser {
    /**
     * 账号
     */
    @ApiModelProperty(value = "账号", name = "userName", example = "12321L")
    private String username;

    /**
     * 密码
     */
    @ApiModelProperty(value = "密码", name = "mPassWord", example = "12321L")
    private String password;
}
