package com.tykj.dev.device.user.subject.entity;


import com.tykj.dev.device.user.base.ret.*;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import javax.persistence.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName User.java
 * @Description 用户对象
 * @createTime 2020年07月27日 11:19:00
 */

@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "用户对象", description = "用户详细信息")
public class User {
    /**
     * 用户
     */

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "用户数据ID", name = "userId", example = "12321L")
//    @GeneratedValue(generator="UserIdentityGenerator",strategy = GenerationType.AUTO)
//    @GenericGenerator(name = "UserIdentityGenerator", strategy = "UserIdentityGenerator")
    private Integer userId;

    /**
     * 真实名称
     */
    @ApiModelProperty(value = "真实名称", name = "name", example = "12321L")
    private String name;

    /**
     * 密码
     */
    @ApiModelProperty(value = "密码", name = "mPassWord", example = "12321L")
    private String password;

    /**
     * 用户名
     */
    @ApiModelProperty(value = "用户名", name = "userName", example = "12321L")
    private String username;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序", name = "showOrder", example = "12321L")
    private Integer showOrder;

    /**
     * 移动电话
     */
    @ApiModelProperty(value = "移动电话", name = "mobile", example = "12321L")
    private String mobile;

    /**
     * 机座
     */
    @ApiModelProperty(value = "机座", name = "telphone", example = "12321L")
    private String telphone;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱", name = "email", example = "12321L")
    private String email;

    /**
     * 真传
     */
    @ApiModelProperty(value = "真传", name = "fax", example = "12321L")
    private String fax;

    /**
     * 状态 默认0，1表示删除
     */
    @ApiModelProperty(value = "状态", name = "isDel", example = "12321L")
    private Integer isDel=0;

    /**
     * 身份证
     */
    @ApiModelProperty(value = "身份证", name = "idCard", example = "12321L")
    private String idCard;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别", name = "sex", example = "12321L")
    private Integer sex;

    /**
     * 用户单位
     */
    @ApiModelProperty(value = "用户单位", name = "unitsId", example = "12321L")
    private Integer unitsId;

    /**
     * 职务
     */
    @ApiModelProperty(value = "用户职务",name = "position")
    private Integer position;

    /**
     * 培训状态 0.已培训 1.已过期 2.未培训 3.快过期
     */
    private Integer trainStatus;
    /**
     * 单位对象
     */
    @Transient
    private Units units;


    public MemberThat toVo(){
        ModelMapper mapper= BeanHelper.getUserMapper();
        return mapper.map(this,MemberThat.class);
    }

    public HandoverUser toHandoverUserVo(){
        ModelMapper mapper= BeanHelper.getUserMapper();
        return mapper.map(this,HandoverUser.class);
    }

    public UserTrainVo toUserTrainVo(){
        ModelMapper mapper= BeanHelper.getUserMapper();
        return mapper.map(this, UserTrainVo.class);
    }

    public UserSuperiorVo toUserSuperiorVo(){
        ModelMapper mapper= BeanHelper.getUserMapper();
        return mapper.map(this, UserSuperiorVo.class);
    }

    public static User toDb(){
        return new User(
              null,
              " ",
              "1234",
              "sa" ,
                1,
                "1234",
                "1234",
                "123@qq.com",
                "123",0,"360218199801052634",0,0,null,0
               ,null
        );
    }

    public UserShenRe toRe(){
        return new UserShenRe(userId,name,trainStatus);
    }

}
