package com.tykj.dev.rfid.entity.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for rfid_change_log
 * RFID修改日志
 * @author admin
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EntityListeners(AuditingEntityListener.class)
@Entity
@SQLDelete(sql = "update rfid_change_log set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("RFID修改日志")
public class RfidChangeLog {

	
	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty(name = "主键id")
	private Integer id ;	
	/**
	* 对应装备IDid
	*/
	@ApiModelProperty(value = "对应装备ID")
	private Integer deviceId ;	
	/**
	* 修改单位
	*/
	@ApiModelProperty(value = "修改单位")
	private String unit ;	
	/**
	* 修改人A
	*/
	@ApiModelProperty(value = "修改人A")
	private Integer userAId ;	
	/**
	* 修改人B
	*/
	@ApiModelProperty(value = "修改人B")
	private Integer userBId ;	
	/**
	* rfid卡号
	*/
	@ApiModelProperty(value = "rfid卡号")
	private String oldCardId ;	
	/**
	* rfid卡号
	*/
	@ApiModelProperty(value = "rfid卡号")
	private String newCardId ;	
	/**
	* 创建用户id
	*/
	@ApiModelProperty(value = "创建用户id")
	@CreatedBy
	private Integer createUserId ;	
	/**
	* 创建时间
	*/
	@ApiModelProperty(value = "创建时间")
	@CreatedDate
	private Date createTime ;
	/**
	* 更新用户id
	*/
	@ApiModelProperty(value = "更新用户id")
	@LastModifiedBy
	private Integer updateUserId ;	
	/**
	* 更新时间
	*/
	@ApiModelProperty(value = "更新时间")
	@LastModifiedDate
	private Date updateTime ;
	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
	private Integer deleteTag  = 0 ;	
	/**
	* 对应装备ID
	*/
	@ApiModelProperty(value = "对应账单ID")
	private Integer rfidChangeBillId ;	
	/**
	* 生效标记(0:未生效，1:已生效)
	*/
	@ApiModelProperty(value = "生效标记(0:未生效，1:已生效)")
	private Integer validTag ;

	public RfidChangeLog(Integer deviceId, String unit, Integer userAId, Integer userBId, String oldCardId, String newCardId, Integer rfidChangeBillId, Integer validTag) {
		this.deviceId = deviceId;
		this.unit = unit;
		this.userAId = userAId;
		this.userBId = userBId;
		this.oldCardId = oldCardId;
		this.newCardId = newCardId;
		this.rfidChangeBillId = rfidChangeBillId;
		this.validTag = validTag;
	}
}
