package com.tykj.dev.rfid.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 描述：
 * @author HuangXiahao
 * @version V1.0
 * @class DateUtils
 * @packageName com.tykj.dev.rfid.utils
 **/
public class DateUtils {

    public static void main(String[] args) throws ParseException {
        Date today = getYearEnd();
        System.out.println("1");
    }

    /**
     * 获取今天
     * @return String
     * */
    public static Date getToday() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = simpleDateFormat.format(new Date());
        return simpleDateFormat.parse(format);
    }
   
    /**
     * 获取本月开始日期
     * @return String
     * **/
    public static Date getMonthStart() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal=Calendar.getInstance();
        cal.add(Calendar.MONTH, 0);
        cal.set(Calendar.DAY_OF_MONTH, 1);
        Date time=cal.getTime();
        String format = simpleDateFormat.format(time);
        return simpleDateFormat.parse(format);
    }
    /**
     * 获取本月最后一天
     * @return String
     * **/
    public static Date getMonthEnd() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal=Calendar.getInstance();
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        Date time=cal.getTime();
        String format = simpleDateFormat.format(time)+" 23:59:59";
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(format);
    }
    /**
     * 获取本周的第一天
     * @return String
     * **/
    public static Date getWeekStart() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal=Calendar.getInstance();
        cal.add(Calendar.WEEK_OF_MONTH, 0);
        cal.set(Calendar.DAY_OF_WEEK, 2);
        Date time=cal.getTime();
        String format = simpleDateFormat.format(time);
        return simpleDateFormat.parse(format);
    }
    /**
     * 获取本周的最后一天
     * @return String
     * **/
    public static Date getWeekEnd() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal=Calendar.getInstance();
        cal.set(Calendar.DAY_OF_WEEK, cal.getActualMaximum(Calendar.DAY_OF_WEEK));
        cal.add(Calendar.DAY_OF_WEEK, 1);
        Date time=cal.getTime();
        String format = simpleDateFormat.format(time)+" 23:59:59";
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(format);
    }
    /**
     * 获取本年的第一天
     * @return String
     * **/
    public static Date getYearStart() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        String format = simpleDateFormat.format(new Date())+"-01-01 00:00:00";
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(format);
    }

    /**
     * 获取本年的最后一天
     * @return String
     * **/
    public static Date getYearEnd() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.MONTH,calendar.getActualMaximum(Calendar.MONTH));
        calendar.set(Calendar.DAY_OF_MONTH,calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
        Date currYearLast = calendar.getTime();
        String format = simpleDateFormat.format(currYearLast)+" 23:59:59";
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(format);

    }
}

