package com.tykj.dev.device.task.service.impl;

import com.tykj.dev.device.task.repository.TaskDao;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.common.StatusEnum;
import com.tykj.dev.device.task.subject.common.StatusMap;
import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.device.task.subject.vo.TaskSelectVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * @author dengdiyi
 */
@Service
public class TaskServiceImpl implements TaskService {
    @Autowired
    private TaskDao taskDao;
    /**
     * <p>业务进行到下一个状态</p>
     * <li>不指定待办用户</li>
     */
    @Override
    public TaskBto moveToNext(TaskBto taskBto) {
        //status++
        taskBto.setBillStatus(StatusMap.getHashMap().getOrDefault(taskBto.getBillStatus()+1, StatusEnum.END).id);
        //list add 0,point++
        taskBto.getInvoleUserIdList().add(0);
        taskBto.setCurrentPoint(taskBto.getCurrentPoint()+1);
        //set readList empty
        taskBto.setUserReadDetailList(Collections.emptyList());
        return taskBto;
    }

    /**
     * <p>业务进行到下一个状态</p>
     * <li>不指定待办用户</li>
     * <li>添加自定义信息</li>
     * @param customInfo 自定义信息
     */
    @Override
    public TaskBto moveToNext(TaskBto taskBto, String customInfo) {
        //status++
        taskBto.setBillStatus(StatusMap.getHashMap().getOrDefault(taskBto.getBillStatus()+1,StatusEnum.END).id);
        //list add 0,point++
        taskBto.getInvoleUserIdList().add(0);
        taskBto.setCurrentPoint(taskBto.getCurrentPoint()+1);
        //set readList empty
        taskBto.setUserReadDetailList(Collections.emptyList());
        //set customInfo
        taskBto.setCustomInfo(customInfo);
        return taskBto;
    }

    /**
     * <p>业务进行到下一个状态（指定待办用户）</p>
     * <li>指定待办用户</li>
     * @param userId 待办用户Id
     */
    @Override
    public TaskBto moveToNext(TaskBto taskBto, Integer userId) {
        //status++
        taskBto.setBillStatus(StatusMap.getHashMap().getOrDefault(taskBto.getBillStatus()+1,StatusEnum.END).id);
        //list add userId,point++
        taskBto.getInvoleUserIdList().add(userId);
        taskBto.setCurrentPoint(taskBto.getCurrentPoint()+1);
        //set readList empty
        taskBto.setUserReadDetailList(Collections.emptyList());
        return taskBto;
    }

    /**
     * <p>业务进行到下一个状态（指定待办用户）</p>
     * <li>指定待办用户</li>
     * <li>添加自定义信息</li>
     * @param userId 待办用户Id
     * @param customInfo 自定义信息
     */
    @Override
    public TaskBto moveToNext(TaskBto taskBto, Integer userId, String customInfo) {
        //status++
        taskBto.setBillStatus(StatusMap.getHashMap().getOrDefault(taskBto.getBillStatus()+1,StatusEnum.END).id);
        //list add userId,point++
        taskBto.getInvoleUserIdList().add(userId);
        taskBto.setCurrentPoint(taskBto.getCurrentPoint()+1);
        //set readList empty
        taskBto.setUserReadDetailList(Collections.emptyList());
        //set customInfo
        taskBto.setCustomInfo(customInfo);
        return taskBto;
    }

    /**
     * <p>业务进行到特殊状态</p>
     * <li>不指定待办用户</li>
     * @param statusEnum 状态枚举
     */
    @Override
    public TaskBto moveToSpecial(TaskBto taskBto, StatusEnum statusEnum) {
        //status++
        taskBto.setBillStatus(statusEnum.id);
        //list add 0,point++
        taskBto.getInvoleUserIdList().add(0);
        taskBto.setCurrentPoint(taskBto.getCurrentPoint()+1);
        //set readList empty
        taskBto.setUserReadDetailList(Collections.emptyList());
        return taskBto;
    }

    /**
     * <p>业务进行到特殊状态</p>
     * <li>不指定待办用户</li>
     * <li>添加自定义信息</li>
     * @param statusEnum 状态枚举
     * @param customInfo 自定义信息
     */
    @Override
    public TaskBto moveToSpecial(TaskBto taskBto, StatusEnum statusEnum, String customInfo) {
        //status++
        taskBto.setBillStatus(statusEnum.id);
        //list add 0,point++
        taskBto.getInvoleUserIdList().add(0);
        taskBto.setCurrentPoint(taskBto.getCurrentPoint()+1);
        //set readList empty
        taskBto.setUserReadDetailList(Collections.emptyList());
        //set customInfo
        taskBto.setCustomInfo(customInfo);
        return taskBto;
    }

    /**
     * <p>业务进行到特殊状态</p>
     * <li>指定待办用户</li>
     * @param statusEnum 状态枚举
     * @param userId 待办用户Id
     */
    @Override
    public TaskBto moveToSpecial(TaskBto taskBto, StatusEnum statusEnum, Integer userId) {
        //status++
        taskBto.setBillStatus(statusEnum.id);
        //list add userId,point++
        taskBto.getInvoleUserIdList().add(userId);
        taskBto.setCurrentPoint(taskBto.getCurrentPoint()+1);
        //set readList empty
        taskBto.setUserReadDetailList(Collections.emptyList());
        return taskBto;
    }

    /**
     * <p>业务进行到特殊状态</p>
     * <li>指定待办用户</li>
     * <li>添加自定义信息</li>
     * @param statusEnum 状态枚举
     * @param userId 待办用户Id
     * @param customInfo 自定义信息
     */
    @Override
    public TaskBto moveToSpecial(TaskBto taskBto, StatusEnum statusEnum, Integer userId, String customInfo) {
        //status++
        taskBto.setBillStatus(statusEnum.id);
        //list add userId,point++
        taskBto.getInvoleUserIdList().add(userId);
        taskBto.setCurrentPoint(taskBto.getCurrentPoint()+1);
        //set readList empty
        taskBto.setUserReadDetailList(Collections.emptyList());
        //set customInfo
        taskBto.setCustomInfo(customInfo);
        return taskBto;
    }

    /**
     * 业务完结
     */
    @Override
    public TaskBto moveToEnd(TaskBto taskBto) {
        //set status end
        taskBto.setBillStatus(StatusEnum.END.id);
        return taskBto;
    }

    /**
     * 业务审核失败封存
     */
    @Override
    public TaskBto moveToArchive(TaskBto taskBto) {
        //set status archive
        taskBto.setBillStatus(StatusEnum.ARCHIVE.id);
        return taskBto;
    }

    /**
     * 新增Task
     */
    @Override
    public Task add(TaskBto taskBto) {
        return taskDao.save(taskBto.toDo());
    }

    /**
     * 更新Task
     *
     * @param taskBto
     */
    @Override
    public Task update(TaskBto taskBto) {
        return taskDao.save(taskBto.toDo());
    }

    /**
     * 根据id获得Task
     *
     * @param id
     */
    @Override
    public TaskBto get(Integer id) {
        Optional<Task> task = taskDao.findById(id);
        return task.map(Task::parse2Bto).orElse(null);
    }

    /**
     * @param taskSelectVo 获取跟踪和待办业务列表
     */
    @Override
    public List<Task> getList(TaskSelectVo taskSelectVo) {
        return null;
    }
}
