package entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceDestotyListVo.java
 * @Description 销毁单列表页
 * @createTime 2020年08月19日 14:04:00
 */
@ApiModel("销毁清单列表")
@AllArgsConstructor
@NoArgsConstructor
@Data
public class DeviceDestroyListVo {

    /**
     * 主键id
     */
    @ApiModelProperty(name = "主键id")
    private Integer id ;
    /**
     * 发起销毁业务经办人id(A岗)
     */
    @ApiModelProperty(value = "发起销毁业务经办人id(A岗)")
    private Integer startUserAId ;
    /**
     * 发起销毁业务审核人id(B岗)
     */
    @ApiModelProperty(value = "发起销毁业务审核人id(B岗)")
    private Integer startUserBId ;
    /**
     * 销毁状态(0:销毁装备出库待审核,1:销毁装备出库审核失败,2:已销毁)
     */
    @ApiModelProperty(value = "销毁状态(0:销毁装备出库待审核,1:销毁装备出库审核失败,2:已销毁)")
    private Integer destoryStatus ;

    /**
     * 装备销毁出库详情(装备主键id+核对结果(0缺失1无误2新增,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的新增
     */
    @ApiModelProperty(value = "装备销毁出库详情(装备主键id+核对结果(0缺失1无误2新增,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的新增")
    private String destoryDeviceDetail ;

    /**
     * 文号
     */
    @Column(name = "doc_number",columnDefinition = "null  int(11) COMMENT ' 文号 '")
    @ApiModelProperty(value = "文号")
    private Integer docNumber ;
    /**
     * 监销人
     */
    @ApiModelProperty(value = "监销人")
    private String supervisor ;
    /**
     * 主管领导
     */
    @ApiModelProperty(value = "主管领导")
    private String leader ;
    /**
     * 承办人
     */
    @ApiModelProperty(value = "承办人")
    private String undertaker ;

    /**
     * 型号
     */
    @ApiModelProperty(value = "型号")
    private String model;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;

}
