package com.tykj.dev.device.task.service;

import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.common.StatusEnum;
import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.device.task.subject.vo.TaskSelectVo;

import java.util.List;

/**
 * @author dengdiyi
 */
public interface TaskService {
    /**
     * <p>业务进行到下一个状态</p>
     * <li>不指定待办用户</li>
     */
    TaskBto moveToNext(TaskBto taskBto);
    /**
     * <p>业务进行到下一个状态</p>
     * <li>不指定待办用户</li>
     * <li>添加自定义信息</li>
     * @param customInfo 自定义信息
     */
    TaskBto moveToNext(TaskBto taskBto, String customInfo);
    /**
     * <p>业务进行到下一个状态（指定待办用户）</p>
     * <li>指定待办用户</li>
     * @param userId 待办用户Id
     */
    TaskBto moveToNext(TaskBto taskBto, Integer userId);
    /**
     * <p>业务进行到下一个状态（指定待办用户）</p>
     * <li>指定待办用户</li>
     * <li>添加自定义信息</li>
     * @param userId 待办用户Id
     * @param customInfo 自定义信息
     */
    TaskBto moveToNext(TaskBto taskBto, Integer userId, String customInfo);
    /**
     * <p>业务进行到特殊状态</p>
     * <li>不指定待办用户</li>
     * @param statusEnum 状态枚举
     */
    TaskBto moveToSpecial(TaskBto taskBto, StatusEnum statusEnum);
    /**
     * <p>业务进行到特殊状态</p>
     * <li>不指定待办用户</li>
     * <li>添加自定义信息</li>
     * @param statusEnum 状态枚举
     * @param customInfo 自定义信息
     */
    TaskBto moveToSpecial(TaskBto taskBto, StatusEnum statusEnum, String customInfo);
    /**
     * <p>业务进行到特殊状态</p>
     * <li>指定待办用户</li>
     * @param statusEnum 状态枚举
     * @param userId 待办用户Id
     */
    TaskBto moveToSpecial(TaskBto taskBto, StatusEnum statusEnum, Integer userId);
    /**
     * <p>业务进行到特殊状态</p>
     * <li>指定待办用户</li>
     * <li>添加自定义信息</li>
     * @param statusEnum 状态枚举
     * @param userId 待办用户Id
     * @param customInfo 自定义信息
     */
    TaskBto moveToSpecial(TaskBto taskBto, StatusEnum statusEnum, Integer userId, String customInfo);
    /**
     * 业务完结
     */
    TaskBto moveToEnd(TaskBto taskBto);
    /**
     * 业务审核失败封存
     */
    TaskBto moveToArchive(TaskBto taskBto);
    /**
     * 新增Task
     */
    Task start(TaskBto taskBto);
    /**
     * 更新Task
     */
    Task update(TaskBto taskBto);
    /**
     * 根据task id获得Task
     */
    TaskBto get(Integer taskId);
    /**
     * 根据billId和businessType获得Task
     */
    TaskBto get(Integer billId,Integer businessType);
    /**
     * @param taskSelectVo
     * 获取跟踪和待办业务列表
     */
    List<Task> getList(TaskSelectVo taskSelectVo);
}
