package com.tykj.dev.device.user.subject.service.impl;

import com.tykj.dev.device.user.subject.dao.RolePermissionsDao;
import com.tykj.dev.device.user.subject.entity.RolePermissions;
import com.tykj.dev.device.user.subject.service.RolePermissionsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RolePermissionsServiceImpl.java
 * @Description TODO
 * @createTime 2020年07月29日 09:00:00
 */
@Service
public class RolePermissionsServiceImpl implements RolePermissionsService {
    @Autowired
    RolePermissionsDao rolePermissionsDao;
    @Override
    public List<RolePermissions> findAllByRoleIds(List<Integer> roleIds) {
        return rolePermissionsDao.findAllByRoleIdIn(roleIds);
    }

    @Override
    public List<RolePermissions> findAllByRoleId(Integer roleId) {
        return rolePermissionsDao.findAllByRoleId(roleId);
    }

    @Override
    public List<RolePermissions> findAllByPermissionsId(Integer permissionsId) {
        return rolePermissionsDao.findAllByPermissionsId(permissionsId);
    }

    @Override
    public void deleteFindRoleId(Integer roleId) {
        rolePermissionsDao.deleteAllByRoleId(roleId);
    }

    @Override
    public RolePermissions save(RolePermissions rolePermissions) {
        return rolePermissionsDao.save(rolePermissions);
    }

    @Override
    public boolean delete(Integer id) {
        rolePermissionsDao.deleteById(id);
        return true;
    }

    @Override
    public List<RolePermissions> findAll() {
        return rolePermissionsDao.findAll();
    }

    @Override
    public RolePermissions update(RolePermissions rolePermissions) {
        return rolePermissionsDao.save(rolePermissions);
    }
}
