package com.tykj.dev.device.packing.subject.vo;

import com.tykj.dev.misc.base.CustomPage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("列装查询类")
public class PackingLibrarySelectVo extends CustomPage {

    @ApiModelProperty(value = "模糊查询关键字",example = "测试")
    public String content;

    @ApiModelProperty(value = "名称",example = "名称")
    public String name;

    @ApiModelProperty(value = "开始时间",example = "2020-10-10 01:10:10")
    public Date startTime;

    @ApiModelProperty(value = "结束时间",example = "2020-10-10 01:10:10")
    public Date endTime;

    @ApiModelProperty(value = "类型",example = "1")
    public Integer type;

    @ApiModelProperty(value = "型号",example = "1234")
    public String model;

    @ApiModelProperty(value = "密级(0:绝密,1:机密,2:秘密)",example = "1")
    private Integer secretLevel;

    @ApiModelProperty(value = "应用领域",example = "1")
    private Integer invisibleRange;
}
