package com.tykj.dev.device.selfcheck.subject.vo;

import com.tykj.dev.device.selfcheck.subject.domin.SelfCheckBill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("自查单保存类")
@Repository
public class SelfExaminationSaveVo {

    @ApiModelProperty(name = "审核人ID",example = "1")
    private Integer userbId;

    @ApiModelProperty(name = "应查数量",example = "1")
    private Integer checkingCount;

    @ApiModelProperty(name = "实查数量",example = "1")
    private Integer checkedCount;

    @ApiModelProperty(name = "自查结果",example = "通过")
    private String checkResult;

    @ApiModelProperty(name = "自查详情",example = "10x21x",value = "自查详情(装备主键id+核对结果(0缺失1无误2新增,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的新增")
    private String checkDetail;

    @ApiModelProperty(name = "新增未记录装备RFID列表")
    private List<String> newDeviceList;

    public SelfCheckBill toDo(){
        SelfCheckBill selfExaminationBillEntity = new SelfCheckBill();
        BeanUtils.copyProperties(this,selfExaminationBillEntity);
        selfExaminationBillEntity.setCheckTime(new Date());
        selfExaminationBillEntity.setCheckStatus(0);
        return selfExaminationBillEntity;
    }
}
