package com.tykj.dev.device.task.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.task.repository.TaskLogDao;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.bto.TaskLogBto;
import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.device.task.subject.domin.TaskLog;
import com.tykj.dev.device.task.subject.vo.TaskLogUserVo;
import com.tykj.dev.device.task.subject.vo.TaskSelectVo;
import com.tykj.dev.device.task.subject.vo.TaskTopVo;
import com.tykj.dev.device.task.subject.vo.TaskUserVo;
import com.tykj.dev.device.task.utils.TaskUtils;
import com.tykj.dev.device.user.util.UserUtils;
import com.tykj.dev.misc.utils.PageUtil;
import com.tykj.dev.misc.utils.ResultUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author dengdiyi
 */
@RestController
@Api(tags = "业务模块",description = "业务模块")
@AutoDocument
@RequestMapping("/business")
public class TaskController {

    @Autowired
    private TaskService taskService;

    @Autowired
    private UserUtils userUtils;

    @Autowired
    private TaskUtils taskUtils;

    @Autowired
    private TaskLogDao taskLogDao;

    @ApiOperation(value = "业务分页查询",notes = "可以通过这个接口分页查询业务")
    @RequestMapping(method = RequestMethod.POST , value = "/manage/summary",produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<Page<TaskUserVo>> getTaskPage(@RequestBody TaskSelectVo taskSelectVo){
        List<TaskUserVo> taskUserVos = taskService.getManageList(taskSelectVo);
        return ResultUtil.success(PageUtil.getPerPage(taskSelectVo.getPage(),taskSelectVo.getSize(),taskUtils.orderByTopDescAndReadAsc(taskUserVos),taskSelectVo.getPageable()));
    }

    @ApiOperation(value = "业务跟踪待办列表查询",notes = "可以通过这个接口查询业务")
    @RequestMapping(method = RequestMethod.POST , value = "/getTaskList",produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<List<TaskUserVo>> getTaskList(@RequestBody TaskSelectVo taskSelectVo){
        List<TaskUserVo> taskUserVos = taskService.getList(taskSelectVo);
        return ResultUtil.success(taskUtils.orderByTopDescAndReadAsc(taskUserVos));
    }

    @ApiOperation(value = "置顶设置",notes = "可以通过这个接口置顶业务")
    @RequestMapping(method = RequestMethod.PUT , value = "/setTop",produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<TaskUserVo> setTop(@RequestBody TaskTopVo taskTopVo){
        TaskBto taskBto = taskService.get(taskTopVo.getTaskId());
        Integer userId = userUtils.getCurrentUserId();
        List<Integer> userIds = taskBto.getTopFlagDetailList();
        if (taskTopVo.getTopFlag()==1) {
            if (userIds!=null) {
                taskBto.getTopFlagDetailList().add(userId);
            }
        }
        if (taskTopVo.getTopFlag()==0){
            if (userIds!=null&&userIds.contains(userId)) {
                userIds.removeAll(new ArrayList<>(Collections.singletonList(userId)));
            }
        }
        Task task = taskService.update(taskBto);
        return ResultUtil.success(task.parse2Bto().toVo());
    }

    @ApiOperation(value = "是否已读设置",notes = "可以通过这个接口设置业务的是否已读")
    @PostMapping("/setRead")
    public ResponseEntity<TaskUserVo> setRead(@RequestBody TaskTopVo taskTopVo){
        TaskBto taskBto = taskService.get(taskTopVo.getTaskId());
        Integer userId = userUtils.getCurrentUserId();
        List<Integer> userIds = taskBto.getUserReadDetailList();
        if (taskTopVo.getTopFlag()==1) {
            if (userIds!=null) {
                taskBto.getTopFlagDetailList().add(userId);
            }
        }
        if (taskTopVo.getTopFlag()==0){
            if (userIds!=null&&userIds.contains(userId)) {
                userIds.removeAll(new ArrayList<>(Collections.singletonList(userId)));
            }
        }
        Task task = taskService.update(taskBto);
        return ResultUtil.success(task.parse2Bto().toVo());
    }

//    @ApiOperation(value = "查询业务对应页面的数据",notes = "可以通过这个接口查询业务对应页面的数据")
//    @GetMapping("/manage/detail/{id}")
//    public ResultObj selectData(@PathVariable("id") int taskId){
//        TaskEntity taskEntity = taskService.getOne(taskId);
//        taskEntity.setJobId(taskUtils.getCurrentJob(taskId).getId());
//        Integer bussinessType = taskEntity.getBussinessType();
//        Integer billId = taskEntity.getBillId();
//        List<Object> list = new ArrayList<>();
//        list.add(taskEntity);
//        switch (bussinessType){
//            case 1:
//                PackingLibraryEntity packingLibraryEntity = packingLibraryService.getOne(billId);
//                packingLibraryEntity.setUserA(userPublicService.getOne(packingLibraryEntity.getUserAId()).getName());
//                packingLibraryEntity.setUserB(userPublicService.getOne(packingLibraryEntity.getUserBId()).getName());
//                list.add(packingLibraryEntity);
//                List<PackingLibraryEntity> packingLibraryEntities= packingLibraryService.selectAllPart(billId);
//                list.add(packingLibraryEntities);
//                return new ResultObj(list,"查询成功");
//            case 2:
//                StorageBillEntity storageBillEntity = storageBillService.getOne(billId);
//                storageBillEntity.setReceiveUserA(userPublicService.getOne(storageBillEntity.getReceiveUserAId()).getName());
//                storageBillEntity.setReceiveUserB(userPublicService.getOne(storageBillEntity.getReceiveUserBId()).getName());
//                list.add(storageBillEntity);
//                String str = storageBillEntity.getStorageDetail();
//                List<Integer> list1= StringSplitUtil.userIdSplit(str);
//                List<DeviceLibraryEntity> libraryEntities = new ArrayList<>();
//                for (Integer id:list1) {
//                    DeviceLibraryEntity deviceLibraryEntity = deviceLibraryService.getOne(id);
//                    libraryEntities.add(deviceLibraryEntity);
//                }
//                list.add(libraryEntities);
//                return new ResultObj(list,"查询成功");
//            case 3:
//                if (taskEntity.getBillId()==0){
//                    TaskEntity applyTask = taskService.getOne(taskEntity.getParentTaskId());
//                    DeviceApplyBillEntity deviceApplyBillEntity = deviceApplyBillService.getOne(applyTask.getBillId());
//                    List<Integer> idList = StringSplitUtil.userIdSplit(deviceApplyBillEntity.getApplyDetail());
//                    List<Integer> packingIdList = new ArrayList<>();
//                    List<Integer> numList = new ArrayList<>();
//                    List<PackingLibraryEntity> packingLibraryEntityList = new ArrayList<>();
//                    if (idList.size()>0){
//                        for (int i=1;i<=idList.size();i++) {
//                            if (i%2==1){
//                                packingIdList.add(idList.get(i-1));
//                            }
//                            else {
//                                numList.add(idList.get(i-1));
//                            }
//                        }
//                    }
//                    if (packingIdList.size()==numList.size()){
//                        for (int i=0;i<packingIdList.size();i++) {
//                            PackingLibraryEntity p = packingLibraryService.getOne(packingIdList.get(i));
//                            p.setApplyNum(numList.get(i));
//                            packingLibraryEntityList.add(p);
//                        }
//                    }
//                    list.add(packingLibraryEntityList);
//                    //查询可配发相同类型装备列表
//                    list.add(deviceLibraryService.getAllotPage(new DeviceLibrarySelectVo()).stream().filter(deviceLibraryEntity -> packingIdList.contains(deviceLibraryEntity.getPackingId())).sorted(Comparator.comparing(DeviceLibraryEntity::getPackingId)).collect(Collectors.toList()));
//                    return new ResultObj(list,"查询成功");
//                }
//                AllotBillEntity allotBillEntity = allotBillService.getOne(billId);
//                allotBillEntity.setSenderUserA(userPublicService.getOne(allotBillEntity.getSendUserAId()).getName());
//                allotBillEntity.setSenderUserB(userPublicService.getOne(allotBillEntity.getSendUserBId()).getName());
//                allotBillEntity.setReceiveUserA(userPublicService.getOne(allotBillEntity.getReceiveUserAId()).getName());
//                Date date = allotBillEntity.getCreateTime();
//                int year = date.getYear()+1900;
//                String s1 ="NO:第"+year+"PF"+allotBillEntity.getId()+"号";
//                allotBillEntity.setNum(s1);
//                if (allotBillEntity.getReceiveUserBId()!=null){
//                    allotBillEntity.setReceiveUserB(userPublicService.getOne(allotBillEntity.getReceiveUserBId()).getName());
//                }
//                list.add(allotBillEntity);
//                String str2 = allotBillEntity.getAllotCheckDetail();
//                String[] strings1 = str2.split("x");
//                List<DeviceLibraryEntity> deviceLibraryEntities = new ArrayList<>();
//                for (String s:strings1) {
//                    if (s.length()>=2&& "1".equals(s.substring(s.length()-1))) {
//                        Integer id = Integer.parseInt(s.substring(0, s.length() - 1));
//                        Integer checkResult = Integer.parseInt(s.substring(s.length()-1));
//                        DeviceLibraryEntity deviceLibraryEntity = deviceLibraryService.getOne(id);
//                        deviceLibraryEntity.setCheckResult(checkResult);
//                        deviceLibraryEntities.add(deviceLibraryEntity);
//                    }
//                }
//                list.add(deviceLibraryEntities);
//                return new ResultObj(list,"查询成功");
//            case 4:
//                SelfExaminationBillEntity selfExaminationBillEntity = selfExaminationBillService.getOne(billId);
//                if (selfExaminationBillEntity.getUserAId()!=0) {
//                    selfExaminationBillEntity.setCheckUser(userPublicService.getOne(selfExaminationBillEntity.getUserAId()).getName());
//                }
//                if (selfExaminationBillEntity.getUserBId()!=0) {
//                    selfExaminationBillEntity.setConfirmUser(userPublicService.getOne(selfExaminationBillEntity.getUserBId()).getName());
//                }
//                list.add(selfExaminationBillEntity);
//                String str3 = selfExaminationBillEntity.getCheckDetail();
//                String str4 = selfExaminationBillEntity.getNewDeviceDetail();
//                String[] split = str3.split("x");
//                if (str4!=null) {
//                    String[] split2 = str4.split("\\.");
//                    List<DeviceLibraryEntity> newDeviceList = new ArrayList<>();
//                    for (String rfid:split2){
//                        if (rfid.length()>0){
//                            DeviceLibraryEntity d = new DeviceLibraryEntity();
//                            d.setCheckResult(2);
//                            d.setSeqNumber("-");
//                            d.setName("-");
//                            d.setType(0);
//                            d.setRfidSurfaceId("-");
//                            d.setProdNumber("-");
//                            d.setRfidCardId(rfid);
//                            newDeviceList.add(d);
//                        }
//                    }
//                    list.add(newDeviceList);
//                }
//                if (str4==null){
//                    List<DeviceLibraryEntity> newDeviceList = new ArrayList<>();
//                    list.add(newDeviceList);
//                }
//                List<DeviceLibraryEntity> libraryEntities1 = new ArrayList<>();
//                for (String s:split) {
//                    if (s.length()>=2) {
//                        Integer id = Integer.parseInt(s.substring(0, s.length() - 1));
//                        Integer checkResult = Integer.parseInt(s.substring(s.length()-1));
//                        DeviceLibraryEntity deviceLibraryEntity = deviceLibraryService.getOne(id);
//                        deviceLibraryEntity.setCheckResult(checkResult);
//                        libraryEntities1.add(deviceLibraryEntity);
//                    }
//                }
//                list.add(libraryEntities1);
//                return new ResultObj(list,"查询成功");
//            case 19:
//                MatchingDeviceBillEntity matchingDeviceBillEntity = matchingDeviceBillService.getOne(billId);
//                list.add(matchingDeviceBillEntity);
//                List<Integer> integerList = StringSplitUtil.userIdSplit(matchingDeviceBillEntity.getDeviceDetail());
//                List<MatchingDeviceLibraryEntity> matchingDeviceLibraryEntities = new ArrayList<>();
//                if (integerList.size()>0){
//                    for (Integer id:integerList) {
//                        if (id>0){
//                            matchingDeviceLibraryEntities.add(matchingDeviceLibraryService.getOne(id));
//                        }
//                    }
//                }
//                list.add(matchingDeviceLibraryEntities);
//                return new ResultObj(list,"查询成功");
//            case 9:
//                DeviceApplyBillEntity deviceApplyBillEntity = deviceApplyBillService.getOne(taskEntity.getBillId());
//                deviceApplyBillEntity.setApplyUser(userPublicService.getOne(deviceApplyBillEntity.getApplyUserAId()).getName());
//                list.add(deviceApplyBillEntity);
//                List<Integer> idList = StringSplitUtil.userIdSplit(deviceApplyBillEntity.getApplyDetail());
//                List<Integer> packingIdList = new ArrayList<>();
//                List<Integer> numList = new ArrayList<>();
//                List<PackingLibraryEntity> packingLibraryEntityList = new ArrayList<>();
//                if (idList.size()>0){
//                    for (int i=1;i<=idList.size();i++) {
//                        if (i%2==1){
//                            packingIdList.add(idList.get(i-1));
//                        }
//                        else {
//                            numList.add(idList.get(i-1));
//                        }
//                    }
//                }
//                if (packingIdList.size()==numList.size()){
//                    for (int i=0;i<packingIdList.size();i++) {
//                        PackingLibraryEntity p = packingLibraryService.getOne(packingIdList.get(i));
//                        p.setApplyNum(numList.get(i));
//                        packingLibraryEntityList.add(p);
//                    }
//                }
//                list.add(packingLibraryEntityList);
//                list.add(deviceLibraryService.getAllotPage(new DeviceLibrarySelectVo()).stream().filter(deviceLibraryEntity -> packingIdList.contains(deviceLibraryEntity.getPackingId())).sorted(Comparator.comparing(DeviceLibraryEntity::getPackingId)).collect(Collectors.toList()));
//                return new ResultObj(list,"查询成功");
//            default: return null;
//        }
//    }
//
//    private List<DeviceLogEntity> orderByTime(List<DeviceLogEntity> list){
//        Collections.sort(list, (o1, o2) -> {
//            int flag = o1.getLogTime().compareTo(o2.getLogTime());
//            return flag;
//        });
//        return list;
//    }
//
    @ApiOperation(value = "查询业务日志",notes = "可以通过这个接口查询查询业务日志")
    @GetMapping("/manage/detail/log/{id}")
    public ResponseEntity<List<TaskLogUserVo>> selectLog(@PathVariable("id") int taskId){
        List<TaskLog> taskLogs = taskUtils.orderByCreateTimeAsc(taskLogDao.getAllByTaskId(taskId));
        return ResultUtil.success(taskLogs.stream().map(TaskLog::parse2bto).map(TaskLogBto::toVo).collect(Collectors.toList()));
    }
}
