package com.tykj.dev.device.task.repository;

import com.tykj.dev.device.task.subject.domin.Task;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;

/**
 * @author dengdiyi
 */
public interface TaskDao extends JpaRepository<Task, Integer>, JpaSpecificationExecutor<Task> {

    /**
     * @param billId 账单id
     * @param businessType 业务类型
     * 根据账单Id和业务类型查询task
     */
    Task findByBillIdAndBusinessType(Integer billId, Integer businessType);
}
