package com.tykj.dev.device.user.base.ret;

import com.tykj.dev.device.user.subject.entity.Permissions;
import com.tykj.dev.device.user.subject.entity.Units;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName UserRe.java
 * @Description 登入成功返回对象
 * @createTime 2020年07月28日 10:57:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "登入成功返回对象", description = "登入成功返回信息")
public class UserRe {

 @ApiModelProperty(value = "用户id", name = "userId", example = "12321L")
 private Integer userId;

 @ApiModelProperty(value = "账号", name = "userName", example = "12321L")
 private String username;

 @ApiModelProperty(value = "真实名称", name = "name", example = "12321L")
 private String name;

 @ApiModelProperty(value = "单位对象", name = "units", example = "12321L")
 private Units units;

 @ApiModelProperty(value = "权限对象", name = "permissions", example = "12321L")
 private Permissions permissions;

}
